/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.item;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.item.CustomCreativeOutput;
import io.github.foundationgames.automobility.util.Eventual;
import io.github.foundationgames.automobility.util.SimpleMapContentRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public abstract class AutomobileComponentItem<T extends AutomobileComponent<T>, V>
extends Item
implements CustomCreativeOutput {
    protected final String translationKey;

    public AutomobileComponentItem(Item.Properties settings, String translationKey) {
        super(settings);
        this.translationKey = translationKey;
    }

    public ItemStack createStack(V componentDescription) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setComponent(stack, componentDescription);
        return stack;
    }

    public abstract void setComponent(ItemStack var1, V var2);

    public abstract T getComponent(ItemStack var1, HolderLookup.Provider var2);

    public abstract ResourceLocation getComponentId(ItemStack var1, T var2);

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        T component = this.getComponent(stack, context.registries());
        ResourceLocation id = this.getComponentId(stack, component);
        String compKey = id.getNamespace() + "." + id.getPath();
        tooltip.add((Component)Component.translatable((String)(this.translationKey + "." + compKey)).withStyle(ChatFormatting.BLUE));
        component.appendTexts(tooltip::add, component);
    }

    public boolean isVisible(T component) {
        return !component.isEmpty();
    }

    protected boolean addToCreative(T component) {
        return !component.isEmpty();
    }

    public static class Builtin<T extends AutomobileComponent<T>>
    extends AutomobileComponentItem<T, T> {
        protected final SimpleMapContentRegistry<T> registry;

        public Builtin(Item.Properties settings, String translationKey, SimpleMapContentRegistry<T> registry) {
            super(settings, translationKey);
            this.registry = registry;
        }

        @Override
        public void setComponent(ItemStack stack, T component) {
            stack.set(AutomobilityItems.COMPONENT_GENERIC_AUTO_PART.require(), (Object)component.getId());
        }

        @Override
        public T getComponent(ItemStack stack, HolderLookup.Provider registries) {
            return (T)((AutomobileComponent)this.registry.getOrDefault((ResourceLocation)stack.get(AutomobilityItems.COMPONENT_GENERIC_AUTO_PART.require())));
        }

        @Override
        public ResourceLocation getComponentId(ItemStack stack, T component) {
            return component.getId();
        }

        @Override
        public void provideCreativeOutput(CreativeModeTab.Output output, HolderLookup.Provider registries) {
            this.registry.forEach(component -> {
                if (this.addToCreative(component)) {
                    output.accept(this.createStack(component));
                }
            });
        }
    }

    public static class Dynamic<T extends AutomobileComponent<T>>
    extends AutomobileComponentItem<T, ResourceKey<T>> {
        public final ResourceKey<Registry<T>> registryKey;
        public final Eventual<DataComponentType<ResourceKey<T>>> dataComponent;
        public final T defaultComponent;

        public Dynamic(Item.Properties settings, String translationKey, ResourceKey<Registry<T>> registryKey, Eventual<DataComponentType<ResourceKey<T>>> dataComponent, T defaultComponent) {
            super(settings, translationKey);
            this.registryKey = registryKey;
            this.dataComponent = dataComponent;
            this.defaultComponent = defaultComponent;
        }

        @Override
        public void setComponent(ItemStack stack, ResourceKey<T> component) {
            stack.set(this.dataComponent.require(), component);
        }

        @Override
        public T getComponent(ItemStack stack, HolderLookup.Provider registries) {
            ResourceKey component = (ResourceKey)stack.get(this.dataComponent.require());
            if (component == null) {
                return this.defaultComponent;
            }
            return (T)registries.lookupOrThrow(this.registryKey).get(component).map(Holder.Reference::value).orElse((AutomobileComponent)this.defaultComponent);
        }

        @Override
        public ResourceLocation getComponentId(ItemStack stack, T component) {
            ResourceKey key = (ResourceKey)stack.get(this.dataComponent.require());
            if (key == null) {
                return Automobility.rl("empty");
            }
            return key.location();
        }

        public Holder<T> lookupComponent(ItemStack stack, HolderLookup.Provider registries) {
            ResourceKey component = (ResourceKey)stack.get(this.dataComponent.require());
            if (component == null) {
                return Holder.direct(this.defaultComponent);
            }
            return registries.lookupOrThrow(this.registryKey).get(component).map(r -> r).orElse(Holder.direct(this.defaultComponent));
        }

        @Override
        public void provideCreativeOutput(CreativeModeTab.Output output, HolderLookup.Provider registries) {
            registries.lookupOrThrow(this.registryKey).listElements().forEach(ref -> ref.unwrapKey().ifPresent(key -> {
                AutomobileComponent component = (AutomobileComponent)ref.value();
                if (this.addToCreative(component)) {
                    output.accept(this.createStack(key));
                }
            }));
        }
    }
}

