/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.entity;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.HitboxEntity;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.util.Eventual;
import io.github.foundationgames.automobility.util.RegistryQueue;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;

public final class AutomobilityEntities
extends Enum<AutomobilityEntities> {
    public static final Eventual<EntityType<AutomobileEntity>> AUTOMOBILE;
    public static final Eventual<EntityType<HitboxEntity>> HITBOX;
    public static final TagKey<EntityType<?>> DASH_PANEL_BOOSTABLES;
    public static final ResourceKey<DamageType> AUTOMOBILE_DAMAGE_SOURCE;
    private static final /* synthetic */ AutomobilityEntities[] $VALUES;

    public static AutomobilityEntities[] values() {
        return (AutomobilityEntities[])$VALUES.clone();
    }

    public static AutomobilityEntities valueOf(String name) {
        return Enum.valueOf(AutomobilityEntities.class, name);
    }

    public static Optional<DamageSource> automobileDamageSource(Level level) {
        return level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(AUTOMOBILE_DAMAGE_SOURCE).map(DamageSource::new);
    }

    public static void init() {
    }

    private static /* synthetic */ AutomobilityEntities[] $values() {
        return new AutomobilityEntities[0];
    }

    static {
        $VALUES = AutomobilityEntities.$values();
        AUTOMOBILE = RegistryQueue.register(BuiltInRegistries.ENTITY_TYPE, Automobility.rl("automobile"), () -> Platform.get().entityType(MobCategory.MISC, AutomobileEntity::new, EntityDimensions.scalable((float)1.0f, (float)0.66f), 3, 10, false, "automobile"));
        HITBOX = RegistryQueue.register(BuiltInRegistries.ENTITY_TYPE, Automobility.rl("hitbox"), () -> Platform.get().entityType(MobCategory.MISC, HitboxEntity::new, EntityDimensions.scalable((float)1.1f, (float)0.7f), 3, 10, true, "automobile_hitbox"));
        DASH_PANEL_BOOSTABLES = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Automobility.rl("dash_panel_boostables"));
        AUTOMOBILE_DAMAGE_SOURCE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Automobility.rl("automobile"));
    }
}

