/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.automobile.DisplayStat;
import io.github.foundationgames.automobility.util.DefaultRegistrar;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public record AutomobileWheel(boolean empty, float size, float grip, WheelModel model) implements AutomobileComponent<AutomobileWheel>
{
    public static final ResourceLocation ID = Automobility.rl("wheel");
    public static final ResourceKey<Registry<AutomobileWheel>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)Automobility.rl("automobile_wheel"));
    public static final DefaultRegistrar<AutomobileWheel> BOOTSTRAP = new DefaultRegistrar<AutomobileWheel>(REGISTRY);
    public static final Codec<AutomobileWheel> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("_empty", (Object)false).forGetter(AutomobileWheel::empty), (App)Codec.FLOAT.fieldOf("size").forGetter(AutomobileWheel::size), (App)Codec.FLOAT.fieldOf("grip").forGetter(AutomobileWheel::grip), (App)WheelModel.CODEC.fieldOf("display").forGetter(AutomobileWheel::model)).apply((Applicative)inst, AutomobileWheel::new));
    public static final Codec<ResourceKey<AutomobileWheel>> CODEC = ResourceKey.codec(REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, AutomobileWheel> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, AutomobileWheel::empty, (StreamCodec)ByteBufCodecs.FLOAT, AutomobileWheel::size, (StreamCodec)ByteBufCodecs.FLOAT, AutomobileWheel::grip, WheelModel.STREAM_CODEC, AutomobileWheel::model, AutomobileWheel::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<AutomobileWheel>> STREAM_CODEC = ByteBufCodecs.holder(REGISTRY, DIRECT_STREAM_CODEC);
    public static final EntityDataSerializer<Holder<AutomobileWheel>> SERIALIZER = EntityDataSerializer.forValueType(STREAM_CODEC);
    public static final AutomobileWheel EMPTY = new AutomobileWheel(true, 0.01f, 0.01f, new WheelModel(1.0f, 1.0f, ResourceLocation.parse((String)"empty"), Automobility.rl("empty")));
    public static final ResourceKey<AutomobileWheel> EMPTY_KEY = BOOTSTRAP.register(Automobility.rl("empty"), EMPTY);
    public static final ResourceKey<AutomobileWheel> STANDARD = BOOTSTRAP.register(Automobility.rl("standard"), AutomobileWheel.of(0.6f, 0.5f, new WheelModel(3.0f, 3.0f, Automobility.rl("textures/entity/automobile/wheel/standard.png"), Automobility.rl("wheel/standard"))));
    public static final ResourceKey<AutomobileWheel> OFF_ROAD = BOOTSTRAP.register(Automobility.rl("off_road"), AutomobileWheel.of(1.1f, 0.8f, new WheelModel(8.4f, 5.0f, Automobility.rl("textures/entity/automobile/wheel/off_road.png"), Automobility.rl("wheel/off_road"))));
    public static final ResourceKey<AutomobileWheel> STEEL = BOOTSTRAP.register(Automobility.rl("steel"), AutomobileWheel.of(0.69f, 0.4f, new WheelModel(3.625f, 3.0f, Automobility.rl("textures/entity/automobile/wheel/steel.png"), Automobility.rl("wheel/steel"))));
    public static final ResourceKey<AutomobileWheel> TRACTOR = BOOTSTRAP.register(Automobility.rl("tractor"), AutomobileWheel.of(1.05f, 0.69f, new WheelModel(3.625f, 3.0f, Automobility.rl("textures/entity/automobile/wheel/tractor.png"), Automobility.rl("wheel/tractor"))));
    public static final ResourceKey<AutomobileWheel> CARRIAGE = AutomobileWheel.carriage("carriage", 0.2f);
    public static final ResourceKey<AutomobileWheel> PLATED = AutomobileWheel.carriage("plated", 0.33f);
    public static final ResourceKey<AutomobileWheel> STREET = AutomobileWheel.carriage("street", 0.5f);
    public static final ResourceKey<AutomobileWheel> GILDED = AutomobileWheel.carriage("gilded", 0.45f);
    public static final ResourceKey<AutomobileWheel> BEJEWELED = AutomobileWheel.carriage("bejeweled", 0.475f);
    public static final DisplayStat<AutomobileWheel> STAT_SIZE = new DisplayStat<AutomobileWheel>("size", AutomobileWheel::size);
    public static final DisplayStat<AutomobileWheel> STAT_GRIP = new DisplayStat<AutomobileWheel>("grip", AutomobileWheel::grip);

    public static AutomobileWheel of(float size, float grip, WheelModel model) {
        return new AutomobileWheel(false, size, grip, model);
    }

    private static ResourceKey<AutomobileWheel> carriage(String name, float grip) {
        return BOOTSTRAP.register(Automobility.rl(name), AutomobileWheel.of(1.05f, grip, new WheelModel(5.0f, 2.0f, Automobility.rl("textures/entity/automobile/wheel/" + name + ".png"), Automobility.rl("wheel/carriage"))));
    }

    @Override
    public boolean isEmpty() {
        return this.empty();
    }

    @Override
    public ResourceLocation containerId() {
        return ID;
    }

    @Override
    public void forEachStat(Consumer<DisplayStat<AutomobileWheel>> action) {
        action.accept(STAT_SIZE);
        action.accept(STAT_GRIP);
    }

    @Override
    public ResourceLocation getId() {
        return Automobility.rl("invalid");
    }

    public static String getTranslationKey(ResourceLocation id) {
        return "wheel." + id.getNamespace() + "." + id.getPath();
    }

    public record WheelModel(float radius, float width, ResourceLocation texture, ResourceLocation modelId) {
        public static final Codec<WheelModel> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("radius").forGetter(WheelModel::radius), (App)Codec.FLOAT.fieldOf("width").forGetter(WheelModel::width), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(WheelModel::texture), (App)ResourceLocation.CODEC.fieldOf("model").forGetter(WheelModel::modelId)).apply((Applicative)inst, WheelModel::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WheelModel> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, WheelModel::radius, (StreamCodec)ByteBufCodecs.FLOAT, WheelModel::width, (StreamCodec)ResourceLocation.STREAM_CODEC, WheelModel::texture, (StreamCodec)ResourceLocation.STREAM_CODEC, WheelModel::modelId, WheelModel::new);
    }
}

