/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.automobile.AutomobileData;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.HornSoundDefinition;
import io.github.foundationgames.automobility.automobile.render.AutomobileModels;
import io.github.foundationgames.automobility.automobile.render.AutomobileRenderer;
import io.github.foundationgames.automobility.automobile.render.BaseModel;
import io.github.foundationgames.automobility.automobile.render.item.SimpleRenderableAutomobile;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.block.entity.render.AutomobileAssemblerBlockEntityRenderer;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.entity.render.AutomobileEntityRenderer;
import io.github.foundationgames.automobility.item.AutomobileComponentItem;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.screen.AutoMechanicTableScreen;
import io.github.foundationgames.automobility.screen.MenuScreenRegistrar;
import io.github.foundationgames.automobility.screen.SingleSlotScreen;
import io.github.foundationgames.automobility.sound.AutomobileSoundInstance;
import io.github.foundationgames.automobility.sound.SlicedLoopingAutomobileSoundInstance;
import io.github.foundationgames.automobility.util.FloatFunc;
import io.github.foundationgames.automobility.util.network.ClientPackets;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;

public class AutomobilityClient {
    public static final BlockColor GRASS_COLOR = (state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0);
    public static final ItemColor GRASS_ITEM_COLOR = (stack, tintIndex) -> GrassColor.get((double)0.5, (double)1.0);

    public static void init() {
        AutomobileModels.init();
        AutomobilityClient.initBlocks();
        AutomobilityClient.initItems();
        AutomobilityClient.initEntities();
        ClientPackets.initClient();
        Platform.get().controller().initCompat();
        Platform.get().registerClientCommand((dispatcher, registries) -> dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"automobilityc").then(LiteralArgumentBuilder.literal((String)"dump").executes(ctx -> {
            if (AutomobilityClient.tryDumpBuiltinResources((HolderLookup.Provider)registries)) {
                AutomobilityClient.sendClientMessage("Dumped all resources to .minecraft/automobility_dump/");
                return 0;
            }
            AutomobilityClient.sendClientMessage("Error dumping resources! See game log for details.");
            return 1;
        }))));
    }

    public static void initBlocks() {
        Platform.get().blockEntityRenderer(AutomobilityBlocks.AUTOMOBILE_ASSEMBLER_ENTITY.require(), AutomobileAssemblerBlockEntityRenderer::new);
    }

    public static void initItems() {
        Platform.get().builtinItemRenderer(AutomobilityItems.AUTOMOBILE.require(), (stack, type, pose, buffers, light, overlay) -> {
            AutomobileData data = (AutomobileData)stack.get(AutomobilityItems.COMPONENT_AUTOMOBILE_DATA.require());
            if (data == null) {
                return;
            }
            ClientLevel lvl = Minecraft.getInstance().level;
            if (lvl == null) {
                return;
            }
            AutomobileFrame frame = (AutomobileFrame)lvl.registryAccess().registryOrThrow(AutomobileFrame.REGISTRY).get(data.frame());
            AutomobileWheel wheel = (AutomobileWheel)lvl.registryAccess().registryOrThrow(AutomobileWheel.REGISTRY).get(data.wheel());
            AutomobileEngine engine = (AutomobileEngine)lvl.registryAccess().registryOrThrow(AutomobileEngine.REGISTRY).get(data.engine());
            if (frame == null || wheel == null || engine == null) {
                return;
            }
            float wheelDist = frame.model().lengthPx() / 16.0f;
            float scale = 1.0f;
            pose.scale(scale /= wheelDist * 0.77f, scale, scale);
            AutomobileRenderer.render(pose, buffers, light, overlay, 0.0f, new SimpleRenderableAutomobile(frame, engine, wheel));
        });
        AutomobilityClient.componentItemRenderer(AutomobilityItems.AUTOMOBILE_FRAME.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 1.0f / (t.model().lengthPx() / 16.0f * 0.77f));
        AutomobilityClient.componentItemRenderer(AutomobilityItems.AUTOMOBILE_WHEEL.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 6.0f / t.model().radius());
        AutomobilityClient.componentItemRenderer(AutomobilityItems.AUTOMOBILE_ENGINE.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 1.0f);
        AutomobilityClient.componentItemRenderer(AutomobilityItems.REAR_ATTACHMENT.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 1.0f);
        AutomobilityClient.componentItemRenderer(AutomobilityItems.FRONT_ATTACHMENT.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> t.model().scale());
        Platform.get().itemModelPredicate(AutomobilityBlocks.AUTOPILOT_SIGN.require().asItem(), Automobility.rl("stop"), (stack, lvl, user, i) -> user != null && user.isUsingItem() ? 1.0f : 0.0f);
    }

    public static void initMenuScreens(MenuScreenRegistrar screens) {
        screens.accept(Automobility.AUTO_MECHANIC_SCREEN, AutoMechanicTableScreen::new);
        screens.accept(Automobility.SINGLE_SLOT_SCREEN, SingleSlotScreen::new);
    }

    public static <T extends AutomobileComponent<T>, V> void componentItemRenderer(AutomobileComponentItem<T, V> item, Function<T, Model> modelProvider, Function<T, ResourceLocation> textureProvider, FloatFunc<T> scaleProvider) {
        Platform.get().builtinItemRenderer(item, (stack, mode, matrices, vertexConsumers, light, overlay) -> {
            ClientLevel lvl = Minecraft.getInstance().level;
            if (lvl == null) {
                return;
            }
            Object component = item.getComponent((ItemStack)stack, (HolderLookup.Provider)lvl.registryAccess());
            if (item.isVisible(component)) {
                Model model = (Model)modelProvider.apply(component);
                if (model == null) {
                    return;
                }
                if (model instanceof BaseModel) {
                    BaseModel base = (BaseModel)model;
                    base.setDefaultState(0.0f);
                }
                float scale = scaleProvider.apply(component);
                matrices.translate(0.5, 0.0, 0.5);
                matrices.scale(scale, -scale, -scale);
                model.renderToBuffer(matrices, vertexConsumers.getBuffer(model.renderType((ResourceLocation)textureProvider.apply(component))), light.intValue(), overlay.intValue(), -1);
                if (model instanceof BaseModel) {
                    BaseModel base = (BaseModel)model;
                    base.doOtherLayerRender((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay);
                }
            }
        });
    }

    public static void initEntities() {
        Platform libs = Platform.get();
        libs.entityRenderer(AutomobilityEntities.AUTOMOBILE.require(), AutomobileEntityRenderer::new);
        libs.entityRenderer(AutomobilityEntities.HITBOX.require(), NoopRenderer::new);
        AutomobileEntity.engineSound = auto -> {
            if (auto.getEngine().isEmpty()) {
                return;
            }
            Minecraft client = Minecraft.getInstance();
            client.getSoundManager().play((SoundInstance)new AutomobileSoundInstance.EngineSound(client, (AutomobileEntity)auto));
        };
        AutomobileEntity.skidSound = auto -> {
            Minecraft client = Minecraft.getInstance();
            client.getSoundManager().play((SoundInstance)new AutomobileSoundInstance.SkiddingSound(client, (AutomobileEntity)auto));
        };
        AutomobileEntity.hornSound = auto -> {
            Minecraft client = Minecraft.getInstance();
            HornSoundDefinition horn = auto.getFrame().horn();
            for (float pitch : horn.pitches()) {
                client.getSoundManager().play((SoundInstance)new SlicedLoopingAutomobileSoundInstance.HornSound(client, (AutomobileEntity)auto, horn, pitch));
            }
        };
    }

    public static double modifyBoostFov(Minecraft client, double old, float tickDelta) {
        LocalPlayer player = client.player;
        Entity entity = player.getVehicle();
        if (entity instanceof AutomobileEntity) {
            AutomobileEntity auto = (AutomobileEntity)entity;
            return old + Math.sqrt(auto.getBoostSpeed(tickDelta)) * 18.0 * (Double)client.options.fovEffectScale().get();
        }
        return old;
    }

    public static boolean tryDumpBuiltinResources(HolderLookup.Provider registries) {
        try {
            AutomobileModels.dump();
            Automobility.dumpDynamicRegistries(registries);
            return true;
        }
        catch (IOException ex) {
            Automobility.LOG.error("Error dumping Automobility resources: ", (Throwable)ex);
            return false;
        }
    }

    public static void sendClientMessage(String message) {
        Minecraft mc = Minecraft.getInstance();
        MutableComponent txt = Component.literal((String)message);
        mc.gui.getChat().addMessage((Component)txt);
        mc.getNarrator().sayNow((Component)txt);
    }
}

