/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.core.registry;

import com.kekecreations.arts_and_crafts.common.entity.ACBoat;
import com.kekecreations.arts_and_crafts.common.item.ACBedBlockItem;
import com.kekecreations.arts_and_crafts.common.item.ACBoatItem;
import com.kekecreations.arts_and_crafts.common.item.ChalkStickItem;
import com.kekecreations.arts_and_crafts.common.item.DyedDecoratedPotBlockItem;
import com.kekecreations.arts_and_crafts.common.item.DyedFlowerPotBlockItem;
import com.kekecreations.arts_and_crafts.common.item.LotusPistilItem;
import com.kekecreations.arts_and_crafts.common.item.PaintbrushItem;
import com.kekecreations.arts_and_crafts.common.item.april_fools.ACFoolItem;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.jinxedlib.core.util.JinxedRegistryHelper;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;

public class ACItems {
    public static final HashMap<Integer, Supplier<DyedFlowerPotBlockItem>> FLOWER_POTS = new HashMap();
    public static final HashMap<Integer, Supplier<ChalkStickItem>> CHALK_STICKS = new HashMap();
    public static final HashMap<DyeColor, Supplier<DyedDecoratedPotBlockItem>> DYED_DECORATED_POT_BLOCK_ITEMS = new HashMap();
    public static final HashMap<DyeColor, Supplier<PaintbrushItem>> PAINT_BRUSHES = new HashMap();
    public static final Supplier<Item> SUS_POTTERY_SHERD = ACItems.registerItem("sus_pottery_sherd", () -> new ACFoolItem(new Item.Properties()));
    public static final Supplier<Item> VICTORY_POTTERY_SHERD = ACItems.registerItem("victory_pottery_sherd", () -> new ACFoolItem(new Item.Properties()));
    public static Supplier<Item> BLEACHED_BED = ACItems.registerItem("bleached_bed", () -> new ACBedBlockItem(ACBlocks.BLEACHED_BED.get(), new Item.Properties().stacksTo(1)));
    public static final Supplier<Item> LOTUS_PISTILS = ACItems.registerItem("lotus_pistils", () -> new LotusPistilItem(new Item.Properties()));
    public static final Supplier<SignItem> CORK_SIGN = ACItems.registerItem("cork_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)ACBlocks.CORK_SIGN.get(), (Block)ACBlocks.CORK_WALL_SIGN.get()));
    public static final Supplier<HangingSignItem> CORK_HANGING_SIGN = ACItems.registerItem("cork_hanging_sign", () -> new HangingSignItem((Block)ACBlocks.CORK_HANGING_SIGN.get(), (Block)ACBlocks.CORK_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
    public static final Supplier<ACBoatItem> CORK_BOAT = ACItems.registerItem("cork_boat", () -> new ACBoatItem(false, ACBoat.WoodType.CORK, new Item.Properties().stacksTo(1)));
    public static final Supplier<ACBoatItem> CORK_CHEST_BOAT = ACItems.registerItem("cork_chest_boat", () -> new ACBoatItem(true, ACBoat.WoodType.CORK, new Item.Properties().stacksTo(1)));
    public static final Supplier<Item> POTTERY_SHERD = ACItems.registerItem("pottery_sherd", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> ROLL_POTTERY_SHERD = ACItems.registerItem("roll_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> RUINED_POTTERY_SHERD = ACItems.registerItem("ruined_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> FINALE_POTTERY_SHERD = ACItems.registerItem("finale_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> GATEWAY_POTTERY_SHERD = ACItems.registerItem("gateway_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> BLEACHDEW = ACItems.registerItem("bleachdew", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> BLEACHDEW_PAINTBRUSH = ACItems.registerItem("bleachdew_paintbrush", () -> new PaintbrushItem(new Item.Properties().stacksTo(1).durability(48)));
    public static final Supplier<ChalkStickItem> BLEACHED_CHALK_STICK = ACItems.registerItem("bleached_chalk_stick", () -> new ChalkStickItem(-1, new Item.Properties().stacksTo(1).durability(32)));

    public static ChalkStickItem getChalkStick(int colours) {
        return CHALK_STICKS.get(colours).get();
    }

    public static DyedDecoratedPotBlockItem getDyedDecoratedPotBlockItem(DyeColor colours) {
        return DYED_DECORATED_POT_BLOCK_ITEMS.get(colours).get();
    }

    public static PaintbrushItem getPaintBrush(int colours) {
        return PAINT_BRUSHES.get(DyeColor.byId((int)colours)).get();
    }

    private static <T extends Item> Supplier<T> registerItem(String name, Supplier<T> itemSupplier) {
        return JinxedRegistryHelper.registerItem((String)"arts_and_crafts", (String)name, itemSupplier);
    }

    public static void register() {
    }

    static {
        CHALK_STICKS.put(-1, BLEACHED_CHALK_STICK);
        for (DyeColor colours : DyeColor.values()) {
            FLOWER_POTS.put(colours.getId(), ACItems.registerItem(String.valueOf(colours) + "_flower_pot", () -> new DyedFlowerPotBlockItem(ACBlocks.getDyedFlowerPot(colours.getId()), new Item.Properties())));
            CHALK_STICKS.put(colours.getId(), ACItems.registerItem(String.valueOf(colours) + "_chalk_stick", () -> new ChalkStickItem(colours.getId(), new Item.Properties().stacksTo(1).durability(32))));
            PAINT_BRUSHES.put(colours, ACItems.registerItem(String.valueOf(colours) + "_paintbrush", () -> new PaintbrushItem(new Item.Properties().stacksTo(1).durability(48))));
            if (colours.getId() > 15) continue;
            DYED_DECORATED_POT_BLOCK_ITEMS.put(colours, ACItems.registerItem(String.valueOf(colours) + "_decorated_pot", () -> new DyedDecoratedPotBlockItem(ACBlocks.getDyedDecoratedPot(colours.getId()), new Item.Properties())));
        }
    }
}

