/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACBuiltInLootTables;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class LotusFlowerBlock
extends WaterlilyBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty SHEARED = BooleanProperty.create((String)"sheared");

    public LotusFlowerBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public int getAge(BlockState p_52306_) {
        return (Integer)p_52306_.getValue((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int $$0) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf($$0));
    }

    public final boolean isMaxAge(BlockState $$0) {
        return this.getAge($$0) >= this.getMaxAge();
    }

    protected static float getGrowthSpeed(ServerLevel level) {
        float growthSpeed = 0.5f;
        if (level.getDayTime() >= 13000L && level.getDayTime() <= 23000L) {
            growthSpeed = 1.0f;
        }
        return growthSpeed;
    }

    public void randomTick(BlockState $$0, ServerLevel $$1, BlockPos $$2, RandomSource $$3) {
        float $$5;
        int $$4;
        if (!((Boolean)$$0.getValue((Property)SHEARED)).booleanValue() && ($$4 = this.getAge($$0)) < this.getMaxAge() && $$3.nextInt((int)(25.0f / ($$5 = LotusFlowerBlock.getGrowthSpeed($$1))) + 1) == 0) {
            $$1.setBlock($$2, (BlockState)this.getStateForAge($$4 + 1).setValue((Property)FACING, (Comparable)((Direction)$$0.getValue((Property)FACING))), 2);
        }
    }

    protected int getBonemealAgeIncrease(Level $$0) {
        return Mth.nextInt((RandomSource)$$0.random, (int)0, (int)1);
    }

    public void growCrops(Level $$0, BlockPos $$1, BlockState $$2) {
        int $$4;
        int $$3 = this.getAge($$2) + this.getBonemealAgeIncrease($$0);
        if ($$3 > ($$4 = this.getMaxAge())) {
            $$3 = $$4;
        }
        $$0.setBlock($$1, (BlockState)this.getStateForAge($$3).setValue((Property)FACING, (Comparable)((Direction)$$2.getValue((Property)FACING))), 2);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)SHEARED) == false && !this.isMaxAge(blockState);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)SHEARED) == false && !this.isMaxAge(blockState);
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        this.growCrops((Level)serverLevel, blockPos, blockState);
    }

    private void dropBleach(Level level, BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)level;
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(ACBuiltInLootTables.LOTUS_FLOWER_HARVEST);
        LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.BLOCK_STATE, (Object)this.defaultBlockState()).create(LootContextParamSets.BLOCK);
        ObjectArrayList itemStackList = lootTable.getRandomItems(lootParams);
        for (ItemStack itemStack : itemStackList) {
            LotusFlowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStack);
        }
        level.playSound(null, pos, SoundEvents.SNIFFER_DROP_SEED, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, @NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (!level.isClientSide() && !((Boolean)blockState.getValue((Property)SHEARED)).booleanValue()) {
            if (itemStack.is(Items.SHEARS)) {
                BlockState blockStateToPlace = ACBlocks.LOTUS_FLOWER.get().defaultBlockState();
                level.setBlockAndUpdate(blockPos, (BlockState)((BlockState)((BlockState)blockStateToPlace.setValue((Property)SHEARED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.AGE_3, (Comparable)((Integer)blockState.getValue((Property)BlockStateProperties.AGE_3)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))));
                if (!player.getAbilities().instabuild) {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (this.isMaxAge(blockState)) {
                this.dropBleach(level, blockPos);
                BlockState blockStateToPlace = ACBlocks.LOTUS_FLOWER.get().defaultBlockState();
                level.setBlockAndUpdate(blockPos, (BlockState)((BlockState)((BlockState)blockStateToPlace.setValue((Property)SHEARED, (Comparable)((Boolean)blockState.getValue((Property)SHEARED)))).setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))));
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    protected boolean mayPlaceOn(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        FluidState fluidState = blockGetter.getFluidState(blockPos);
        FluidState fluidState2 = blockGetter.getFluidState(blockPos.above());
        return (fluidState.getType() == Fluids.WATER || blockState.getBlock() instanceof IceBlock) && fluidState2.getType() == Fluids.EMPTY;
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos $$1, BlockState $$2) {
        return ACItems.LOTUS_PISTILS.get().getDefaultInstance();
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SHEARED, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{AGE});
        blockStateBuilder.add(new Property[]{FACING});
        blockStateBuilder.add(new Property[]{SHEARED});
    }
}

