/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.common.util.ACProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingFlowerPot
extends Block {
    public static final BooleanProperty PLANK;
    public static final DirectionProperty FACING;
    private static final VoxelShape FLOWER_POT_SHAPE;
    private static final VoxelShape PLANK_SHAPE_EAST_AND_WEST;
    private static final VoxelShape PLANK_SHAPE_NORTH_AND_SOUTH;
    private static final VoxelShape AABB_EAST_AND_WEST;
    private static final VoxelShape AABB_NORTH_AND_SOUTH;

    public HangingFlowerPot(BlockBehaviour.Properties $$0) {
        super($$0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLANK, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{PLANK});
        blockStateBuilder.add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        if (((Boolean)blockState.getValue((Property)ACProperties.PLANK)).booleanValue()) {
            if (blockState.getValue((Property)FACING) == Direction.EAST || blockState.getValue((Property)FACING) == Direction.WEST) {
                return AABB_EAST_AND_WEST;
            }
            if (blockState.getValue((Property)FACING) == Direction.NORTH || blockState.getValue((Property)FACING) == Direction.SOUTH) {
                return AABB_NORTH_AND_SOUTH;
            }
        }
        return FLOWER_POT_SHAPE;
    }

    static {
        FLOWER_POT_SHAPE = Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
        PLANK_SHAPE_EAST_AND_WEST = Block.box((double)7.0, (double)14.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        PLANK_SHAPE_NORTH_AND_SOUTH = Block.box((double)0.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        PLANK = ACProperties.PLANK;
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        AABB_EAST_AND_WEST = Shapes.or((VoxelShape)PLANK_SHAPE_EAST_AND_WEST, (VoxelShape[])new VoxelShape[]{FLOWER_POT_SHAPE});
        AABB_NORTH_AND_SOUTH = Shapes.or((VoxelShape)PLANK_SHAPE_NORTH_AND_SOUTH, (VoxelShape[])new VoxelShape[]{FLOWER_POT_SHAPE});
    }
}

