/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class ChalkDustParticle
extends SimpleAnimatedParticle {
    double velX;
    double velY;
    double velZ;

    ChalkDustParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, 0.0f);
        this.velX = velocityX;
        this.velY = velocityY;
        this.velZ = velocityZ;
        this.xd = this.velX;
        this.yd = this.velY;
        this.zd = this.velZ;
        this.quadSize = 0.16f;
        this.hasPhysics = true;
        this.gravity = 0.1f;
        this.lifetime = 40;
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        super.tick();
        this.xd = this.velX;
        this.zd = this.velZ;
        int magnitude = 2;
        int smoothness = 300;
        this.velX += (double)((float)this.random.nextIntBetweenInclusive(-magnitude, magnitude) / (float)smoothness);
        this.velZ += (double)((float)this.random.nextIntBetweenInclusive(-magnitude, magnitude) / (float)smoothness);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new ChalkDustParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

