/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.neoforge.client;

import com.kekecreations.arts_and_crafts.client.particle.ChalkDustParticle;
import com.kekecreations.arts_and_crafts.client.renderer.bewlr.ArtsAndCraftsBEWLR;
import com.kekecreations.arts_and_crafts.client.renderer.entity.ACBoatRenderer;
import com.kekecreations.arts_and_crafts.client.renderer.entity.FloatingBlockRenderer;
import com.kekecreations.arts_and_crafts.client.renderer.tile.ACBedBER;
import com.kekecreations.arts_and_crafts.client.renderer.tile.DyedDecoratedPotBER;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACEntityTypes;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import com.kekecreations.arts_and_crafts.core.registry.ACParticles;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@ParametersAreNonnullByDefault
@EventBusSubscriber(modid="arts_and_crafts", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerBEWLR(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ArtsAndCraftsBEWLR();
            }
        }, new Item[]{ACItems.BLEACHED_BED.get()});
        for (DyeColor colour : DyeColor.values()) {
            event.registerItem(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new ArtsAndCraftsBEWLR();
                }
            }, new Item[]{ACItems.getDyedDecoratedPotBlockItem(colour)});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ACEntityTypes.FLOATING_BLOCK.get(), FloatingBlockRenderer::new);
        event.registerEntityRenderer(ACEntityTypes.BOAT.get(), context -> new ACBoatRenderer(context, false));
        event.registerEntityRenderer(ACEntityTypes.CHEST_BOAT.get(), context -> new ACBoatRenderer(context, true));
        event.registerBlockEntityRenderer(ACEntityTypes.CUSTOM_DECORATED_POT_BLOCK_ENTITY.get(), DyedDecoratedPotBER::new);
        event.registerBlockEntityRenderer(ACEntityTypes.CUSTOM_BED_BLOCK_ENTITY.get(), ACBedBER::new);
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ACBoatRenderer.BOAT, BoatModel::createBodyModel);
        event.registerLayerDefinition(ACBoatRenderer.CHEST_BOAT, ChestBoatModel::createBodyModel);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent registerParticleProvidersEvent) {
        for (DyeColor colours : DyeColor.values()) {
            registerParticleProvidersEvent.registerSpriteSet((ParticleType)ACParticles.getChalkDrawParticle(colours.getId()), ChalkDustParticle.Factory::new);
        }
        registerParticleProvidersEvent.registerSpriteSet((ParticleType)ACParticles.BLEACHED_CHALK_DRAW.get(), ChalkDustParticle.Factory::new);
    }

    @SubscribeEvent
    public static void registerBlockColours(RegisterColorHandlersEvent.Block registerColorHandlersEvent) {
        for (DyeColor colours : DyeColor.values()) {
            registerColorHandlersEvent.register((blockState, blockAndTintGetter, blockPos, i) -> {
                if (blockAndTintGetter == null || blockPos == null) {
                    return GrassColor.getDefaultColor();
                }
                return BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
            }, new Block[]{ACBlocks.getDyedPottedFern(colours)});
        }
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        for (DyeColor colours : DyeColor.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getChalkDust(colours.getId()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCrimsonFungus(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCrimsonRoots(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWarpedFungus(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWarpedRoots(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedOakSapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedSpruceSapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBirchSapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAcaciaSapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedJungleSapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCherrySapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedDarkOakSapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedMangrovePropagule(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedFern(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedDandelion(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedPoppy(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBlueOrchid(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAllium(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAzureBluet(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedRedTulip(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedOrangeTulip(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWhiteTulip(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedPinkTulip(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedOxeyeDaisy(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCornflower(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedLilyOfTheValley(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWitherRose(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedRedMushroom(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBrownMushroom(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedDeadBush(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCactus(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBamboo(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAzalea(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedFloweringAzalea(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedTorchFlower(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCorkSapling(colours), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPlaster(colours.getId()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedFlowerPot(colours.getId()), (RenderType)RenderType.cutout());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ACBlocks.CORK_SAPLING.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ACBlocks.POTTED_CORK_SAPLING.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ACBlocks.PLASTER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.LOTUS_FLOWER.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.BLEACHED_CHALK_DUST.get(), (RenderType)RenderType.cutout());
    }
}

