/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.neoforge;

import com.kekecreations.arts_and_crafts.ArtsAndCrafts;
import com.kekecreations.arts_and_crafts.common.item.palette.PaintbrushPalette;
import com.kekecreations.arts_and_crafts.common.util.PietraforteColour;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import com.kekecreations.arts_and_crafts.core.registry.ACRegistries;
import com.kekecreations.arts_and_crafts.neoforge.common.event.OnWorldLoadEvent;
import com.kekecreations.arts_and_crafts.neoforge.core.config.NeoForgeConfig;
import com.kekecreations.arts_and_crafts.neoforge.core.registry.ACLootModifiers;
import com.kekecreations.arts_and_crafts.neoforge.datagen.client.ArtsAndCraftsBlockStateProvider;
import com.kekecreations.arts_and_crafts.neoforge.datagen.client.ArtsAndCraftsItemModelProvider;
import com.kekecreations.arts_and_crafts.neoforge.datagen.client.ArtsAndCraftsLangProvider;
import com.kekecreations.arts_and_crafts.neoforge.datagen.server.ArtsAndCraftsBiomeTagsProvider;
import com.kekecreations.arts_and_crafts.neoforge.datagen.server.ArtsAndCraftsBlockTagsProvider;
import com.kekecreations.arts_and_crafts.neoforge.datagen.server.ArtsAndCraftsItemTagsProvider;
import com.kekecreations.arts_and_crafts.neoforge.datagen.server.ArtsAndCraftsLootTableProvider;
import com.kekecreations.arts_and_crafts.neoforge.datagen.server.ArtsAndCraftsRecipeProvider;
import com.kekecreations.jinxedlib.core.util.JinxedCreativeCategoryUtils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@Mod(value="arts_and_crafts")
public class ArtsAndCraftsNeoForge {
    public ArtsAndCraftsNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        ArtsAndCrafts.init();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeoForgeConfig.SPEC);
        ACLootModifiers.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)new OnWorldLoadEvent());
        modEventBus.addListener(this::creativeItemGroups);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::datapackRegistry);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ArtsAndCraftsLangProvider(packOutput, "arts_and_crafts"));
        generator.addProvider(event.includeClient(), (DataProvider)new ArtsAndCraftsItemModelProvider(packOutput, "arts_and_crafts", fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ArtsAndCraftsBlockStateProvider(packOutput, "arts_and_crafts", fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsRecipeProvider(packOutput, lookupProvider));
        ArtsAndCraftsBlockTagsProvider blockTagProvider = new ArtsAndCraftsBlockTagsProvider(packOutput, lookupProvider, "arts_and_crafts", fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsItemTagsProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), "arts_and_crafts", fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsBiomeTagsProvider(packOutput, lookupProvider, "arts_and_crafts", fileHelper));
    }

    public void datapackRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(ACRegistries.PAINTBRUSH_PALETTE, PaintbrushPalette.CODEC);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Item beforeItem, Item item) {
        event.insertAfter(beforeItem.getDefaultInstance(), item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Block beforeItem, Item item) {
        event.insertAfter(beforeItem.asItem().getDefaultInstance(), item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Item beforeItem, Block item) {
        event.insertAfter(beforeItem.getDefaultInstance(), item.asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Block beforeItem, Block item) {
        event.insertAfter(beforeItem.asItem().getDefaultInstance(), item.asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addBefore(BuildCreativeModeTabContentsEvent event, Block beforeItem, Block item) {
        event.insertBefore(beforeItem.asItem().getDefaultInstance(), item.asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addBefore(BuildCreativeModeTabContentsEvent event, Item beforeItem, Item item) {
        event.insertBefore(beforeItem.getDefaultInstance(), item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void creativeItemGroups(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            this.addAfter(event, Blocks.PINK_GLAZED_TERRACOTTA, ACBlocks.TERRACOTTA_SHINGLES.get());
            this.addAfter(event, ACBlocks.TERRACOTTA_SHINGLES.get(), (Block)ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get(), (Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get(), (Block)ACBlocks.TERRACOTTA_SHINGLE_WALL.get());
            for (DyeColor colour : JinxedCreativeCategoryUtils.colourOrderBackToFront) {
                this.addAfter(event, Items.PINK_BANNER, ACBlocks.getChalk(colour.getId()));
            }
            this.addAfter(event, ACBlocks.getChalk(DyeColor.PINK.getId()), ACBlocks.SOAPSTONE.get());
            this.addAfter(event, ACBlocks.SOAPSTONE.get(), (Block)ACBlocks.SOAPSTONE_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_STAIRS.get(), (Block)ACBlocks.SOAPSTONE_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_SLAB.get(), (Block)ACBlocks.SOAPSTONE_WALL.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_WALL.get(), ACBlocks.POLISHED_SOAPSTONE.get());
            this.addAfter(event, ACBlocks.POLISHED_SOAPSTONE.get(), (Block)ACBlocks.POLISHED_SOAPSTONE_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_SOAPSTONE_STAIRS.get(), (Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get(), (Block)ACBlocks.POLISHED_SOAPSTONE_WALL.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_SOAPSTONE_WALL.get(), ACBlocks.SOAPSTONE_BRICKS.get());
            this.addAfter(event, ACBlocks.SOAPSTONE_BRICKS.get(), (Block)ACBlocks.SOAPSTONE_BRICK_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_BRICK_STAIRS.get(), (Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get(), (Block)ACBlocks.SOAPSTONE_BRICK_WALL.get());
            this.addAfter(event, Blocks.PINK_STAINED_GLASS_PANE, (Block)ACBlocks.PLASTER.get());
            this.addBefore(event, Blocks.WHITE_WOOL, ACBlocks.BLEACHED_WOOL.get());
            this.addBefore(event, Blocks.WHITE_CARPET, ACBlocks.BLEACHED_CARPET.get());
            this.addBefore(event, Blocks.WHITE_CONCRETE, ACBlocks.BLEACHED_CONCRETE.get());
            this.addBefore(event, Blocks.WHITE_CONCRETE_POWDER, ACBlocks.BLEACHED_CONCRETE_POWDER.get());
            this.addBefore(event, Blocks.WHITE_GLAZED_TERRACOTTA, ACBlocks.GLAZED_TERRACOTTA.get());
            this.addBefore(event, Blocks.WHITE_BED, ACBlocks.BLEACHED_BED.get());
            for (DyeColor colours : JinxedCreativeCategoryUtils.colourOrderBackToFront) {
                this.addAfter(event, Items.PINK_CANDLE, ACBlocks.getDyedFlowerPot(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedFlowerPot(DyeColor.PINK.getId()), ACBlocks.getDyedDecoratedPot(colours.getId()));
                this.addAfter(event, (Block)ACBlocks.TERRACOTTA_SHINGLE_WALL.get(), ACBlocks.getDyedTerracottaShingles(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedTerracottaShingles(colours.getId()), ACBlocks.getDyedTerracottaShingleStairs(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedTerracottaShingleStairs(colours.getId()), ACBlocks.getDyedTerracottaShingleSlab(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedTerracottaShingleSlab(colours.getId()), ACBlocks.getDyedTerracottaShingleWall(colours.getId()));
                this.addAfter(event, (Block)ACBlocks.SOAPSTONE_BRICK_WALL.get(), ACBlocks.getDyedSoapstone(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstone(colours.getId()), ACBlocks.getDyedSoapstoneStairs(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneStairs(colours.getId()), ACBlocks.getDyedSoapstoneSlab(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneSlab(colours.getId()), ACBlocks.getDyedSoapstoneWall(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneWall(colours.getId()), ACBlocks.getDyedPolishedSoapstone(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstone(colours.getId()), ACBlocks.getDyedPolishedSoapstoneStairs(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstoneStairs(colours.getId()), ACBlocks.getDyedPolishedSoapstoneSlab(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstoneSlab(colours.getId()), ACBlocks.getDyedPolishedSoapstoneWall(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstoneWall(colours.getId()), ACBlocks.getDyedSoapstoneBricks(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBricks(colours.getId()), ACBlocks.getDyedSoapstoneBrickStairs(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBrickStairs(colours.getId()), ACBlocks.getDyedSoapstoneBrickSlab(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBrickSlab(colours.getId()), ACBlocks.getDyedSoapstoneBrickWall(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBrickWall(DyeColor.PINK.getId()), ACBlocks.getDyedMudBricks(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedMudBricks(colours.getId()), ACBlocks.getDyedMudBrickStairs(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedMudBrickStairs(colours.getId()), ACBlocks.getDyedMudBrickSlab(colours.getId()));
                this.addAfter(event, ACBlocks.getDyedMudBrickSlab(colours.getId()), ACBlocks.getDyedMudBrickWall(colours.getId()));
                this.addAfter(event, (Block)ACBlocks.PLASTER.get(), ACBlocks.getDyedPlaster(colours.getId()));
            }
            this.addBefore(event, ACBlocks.getChalk(DyeColor.WHITE.getId()), ACBlocks.BLEACHED_CHALK.get());
            for (PietraforteColour colour : PietraforteColour.values()) {
                this.addAfter(event, ACBlocks.getDyedMudBrickWall(DyeColor.PINK.getId()), ACBlocks.getPietraforte(colour));
                this.addAfter(event, ACBlocks.getPietraforte(colour), (Block)ACBlocks.getPietraforteStairs(colour));
                this.addAfter(event, (Block)ACBlocks.getPietraforteStairs(colour), (Block)ACBlocks.getPietraforteSlab(colour));
                this.addAfter(event, (Block)ACBlocks.getPietraforteSlab(colour), (Block)ACBlocks.getPietraforteWall(colour));
                this.addAfter(event, (Block)ACBlocks.getPietraforteWall(colour), ACBlocks.getCobbledPietraforte(colour));
                this.addAfter(event, ACBlocks.getCobbledPietraforte(colour), (Block)ACBlocks.getCobbledPietraforteStairs(colour));
                this.addAfter(event, (Block)ACBlocks.getCobbledPietraforteStairs(colour), (Block)ACBlocks.getCobbledPietraforteSlab(colour));
                this.addAfter(event, (Block)ACBlocks.getCobbledPietraforteSlab(colour), (Block)ACBlocks.getCobbledPietraforteWall(colour));
                this.addAfter(event, (Block)ACBlocks.getCobbledPietraforteWall(colour), ACBlocks.getChiseledPietraforte(colour));
                this.addAfter(event, ACBlocks.getChiseledPietraforte(colour), ACBlocks.getPietraforteBricks(colour));
                this.addAfter(event, ACBlocks.getPietraforteBricks(colour), (Block)ACBlocks.getPietraforteBrickStairs(colour));
                this.addAfter(event, (Block)ACBlocks.getPietraforteBrickStairs(colour), (Block)ACBlocks.getPietraforteBrickSlab(colour));
                this.addAfter(event, (Block)ACBlocks.getPietraforteBrickSlab(colour), (Block)ACBlocks.getPietraforteBrickWall(colour));
                this.addAfter(event, (Block)ACBlocks.getPietraforteBrickWall(colour), (Block)ACBlocks.getPietrafortePillar(colour));
                this.addAfter(event, (Block)ACBlocks.getPietrafortePillar(colour), ACBlocks.getSmoothPietraforte(colour));
                this.addAfter(event, ACBlocks.getSmoothPietraforte(colour), (Block)ACBlocks.getSmoothPietraforteStairs(colour));
                this.addAfter(event, (Block)ACBlocks.getSmoothPietraforteStairs(colour), (Block)ACBlocks.getSmoothPietraforteSlab(colour));
                this.addAfter(event, (Block)ACBlocks.getSmoothPietraforteSlab(colour), (Block)ACBlocks.getSmoothPietraforteWall(colour));
                this.addAfter(event, (Block)ACBlocks.getSmoothPietraforteWall(colour), ACBlocks.getCutPietraforte(colour));
                this.addAfter(event, ACBlocks.getCutPietraforte(colour), (Block)ACBlocks.getCutPietraforteStairs(colour));
                this.addAfter(event, (Block)ACBlocks.getCutPietraforteStairs(colour), (Block)ACBlocks.getCutPietraforteSlab(colour));
                this.addAfter(event, (Block)ACBlocks.getCutPietraforteSlab(colour), (Block)ACBlocks.getCutPietraforteWall(colour));
            }
        }
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.accept((ItemLike)ACBlocks.getChalk(DyeColor.WHITE.getId()));
            event.accept((ItemLike)ACBlocks.SOAPSTONE.get());
            event.accept((ItemLike)ACBlocks.GYPSUM.get());
            this.addAfter(event, Blocks.ACACIA_LOG, (Block)ACBlocks.CORK_LOG.get());
            this.addAfter(event, Blocks.ACACIA_LEAVES, (Block)ACBlocks.CORK_LEAVES.get());
            this.addAfter(event, Blocks.ACACIA_SAPLING, (Block)ACBlocks.CORK_SAPLING.get());
            this.addAfter(event, Items.LILY_PAD, ACItems.LOTUS_PISTILS.get());
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            for (DyeColor colours : JinxedCreativeCategoryUtils.colourOrderBackToFront) {
                this.addAfter(event, Items.TNT_MINECART, (Item)ACItems.getChalkStick(colours.getId()));
                this.addAfter(event, Items.BRUSH, (Item)ACItems.getPaintBrush(colours.getId()));
            }
            this.addBefore(event, ACItems.getChalkStick(DyeColor.WHITE.getId()), ACItems.BLEACHED_CHALK_STICK.get());
            this.addBefore(event, ACItems.getPaintBrush(DyeColor.WHITE.getId()), ACItems.BLEACHDEW_PAINTBRUSH.get());
            this.addAfter(event, Items.ACACIA_CHEST_BOAT, (Item)ACItems.CORK_BOAT.get());
            this.addAfter(event, (Item)ACItems.CORK_BOAT.get(), (Item)ACItems.CORK_CHEST_BOAT.get());
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            for (DyeColor colours : JinxedCreativeCategoryUtils.colourOrderBackToFront) {
                this.addAfter(event, Items.FLOWER_POT, ACBlocks.getDyedFlowerPot(colours.getId()));
                this.addAfter(event, Items.DECORATED_POT, ACBlocks.getDyedDecoratedPot(colours.getId()));
            }
            this.addAfter(event, Items.ACACIA_HANGING_SIGN, (Item)ACItems.CORK_SIGN.get());
            this.addAfter(event, (Item)ACItems.CORK_SIGN.get(), (Item)ACItems.CORK_HANGING_SIGN.get());
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            this.addAfter(event, Blocks.ACACIA_BUTTON, (Block)ACBlocks.CORK_LOG.get());
            this.addAfter(event, (Block)ACBlocks.CORK_LOG.get(), (Block)ACBlocks.CORK_WOOD.get());
            this.addAfter(event, (Block)ACBlocks.CORK_WOOD.get(), (Block)ACBlocks.STRIPPED_CORK_LOG.get());
            this.addAfter(event, (Block)ACBlocks.STRIPPED_CORK_LOG.get(), (Block)ACBlocks.STRIPPED_CORK_WOOD.get());
            this.addAfter(event, (Block)ACBlocks.STRIPPED_CORK_WOOD.get(), (Block)ACBlocks.CORK.get());
            this.addAfter(event, (Block)ACBlocks.CORK.get(), (Block)ACBlocks.SMOOTH_CORK.get());
            this.addAfter(event, (Block)ACBlocks.SMOOTH_CORK.get(), (Block)ACBlocks.CORK_PLANKS.get());
            this.addAfter(event, (Block)ACBlocks.CORK_PLANKS.get(), (Block)ACBlocks.CORK_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.CORK_STAIRS.get(), (Block)ACBlocks.CORK_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.CORK_SLAB.get(), (Block)ACBlocks.CORK_FENCE.get());
            this.addAfter(event, (Block)ACBlocks.CORK_FENCE.get(), (Block)ACBlocks.CORK_FENCE_GATE.get());
            this.addAfter(event, (Block)ACBlocks.CORK_FENCE_GATE.get(), (Block)ACBlocks.CORK_DOOR.get());
            this.addAfter(event, (Block)ACBlocks.CORK_DOOR.get(), (Block)ACBlocks.CORK_TRAPDOOR.get());
            this.addAfter(event, (Block)ACBlocks.CORK_TRAPDOOR.get(), (Block)ACBlocks.CORK_PRESSURE_PLATE.get());
            this.addAfter(event, (Block)ACBlocks.CORK_PRESSURE_PLATE.get(), (Block)ACBlocks.CORK_BUTTON.get());
            this.addAfter(event, Blocks.MUD_BRICK_WALL, ACBlocks.GYPSUM.get());
            this.addAfter(event, ACBlocks.GYPSUM.get(), (Block)ACBlocks.GYPSUM_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_STAIRS.get(), (Block)ACBlocks.GYPSUM_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_SLAB.get(), (Block)ACBlocks.GYPSUM_WALL.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_WALL.get(), ACBlocks.POLISHED_GYPSUM.get());
            this.addAfter(event, ACBlocks.POLISHED_GYPSUM.get(), (Block)ACBlocks.POLISHED_GYPSUM_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_GYPSUM_STAIRS.get(), (Block)ACBlocks.POLISHED_GYPSUM_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_GYPSUM_SLAB.get(), (Block)ACBlocks.POLISHED_GYPSUM_WALL.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_GYPSUM_WALL.get(), ACBlocks.GYPSUM_BRICKS.get());
            this.addAfter(event, ACBlocks.GYPSUM_BRICKS.get(), (Block)ACBlocks.GYPSUM_BRICK_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_BRICK_STAIRS.get(), (Block)ACBlocks.GYPSUM_BRICK_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_BRICK_SLAB.get(), (Block)ACBlocks.GYPSUM_BRICK_WALL.get());
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            this.addAfter(event, Items.PRIZE_POTTERY_SHERD, ACItems.ROLL_POTTERY_SHERD.get());
            this.addBefore(event, Items.FRIEND_POTTERY_SHERD, ACItems.FINALE_POTTERY_SHERD.get());
            this.addAfter(event, Items.FRIEND_POTTERY_SHERD, ACItems.GATEWAY_POTTERY_SHERD.get());
            this.addBefore(event, Items.ANGLER_POTTERY_SHERD, ACItems.RUINED_POTTERY_SHERD.get());
            this.addBefore(event, ACItems.RUINED_POTTERY_SHERD.get(), ACItems.POTTERY_SHERD.get());
            this.addAfter(event, Items.SNORT_POTTERY_SHERD, ACItems.SUS_POTTERY_SHERD.get());
            this.addAfter(event, ACItems.SUS_POTTERY_SHERD.get(), ACItems.VICTORY_POTTERY_SHERD.get());
            this.addBefore(event, Items.WHITE_DYE, ACItems.BLEACHDEW.get());
        }
    }
}

