/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.util;

import com.kekecreations.arts_and_crafts.common.entity.DyedDecoratedPotBlockEntity;
import com.kekecreations.arts_and_crafts.common.item.palette.PaintbrushPalette;
import com.kekecreations.arts_and_crafts.core.mixin.DecoratedPotBlockEntityAccessor;
import com.kekecreations.arts_and_crafts.core.registry.ACRegistries;
import com.kekecreations.arts_and_crafts.core.registry.ACSounds;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PaintbrushUtils {
    public static void setPotDecorations(Level level, BlockPos pos, PotDecorations decorations) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DyedDecoratedPotBlockEntity) {
            DyedDecoratedPotBlockEntity dyedPot = (DyedDecoratedPotBlockEntity)blockEntity;
            dyedPot.setDecoration(decorations);
        } else if (blockEntity instanceof DecoratedPotBlockEntityAccessor) {
            DecoratedPotBlockEntityAccessor decoratedPot = (DecoratedPotBlockEntityAccessor)blockEntity;
            decoratedPot.setDecorations(decorations);
        }
    }

    @Nullable
    public static Block getFinalBlock(RegistryAccess access, BlockState state, ItemStack stack) {
        Optional<PaintbrushPalette> optionalPalette = access.registryOrThrow(ACRegistries.PAINTBRUSH_PALETTE).stream().filter(searchPalette -> searchPalette.blocks().contains(state.getBlockHolder())).findFirst();
        if (optionalPalette.isEmpty()) {
            return null;
        }
        PaintbrushPalette palette = optionalPalette.get();
        Holder<Block> holder = palette.mappings().get(stack.getItemHolder());
        if (holder.unwrapKey().isEmpty()) {
            return null;
        }
        return (Block)access.registryOrThrow(Registries.BLOCK).getOrThrow((ResourceKey)holder.unwrapKey().get());
    }

    public static void damagePaintbrushWhenPainting(Level level, Player player, ItemStack itemStack, BlockState blockState, BlockPos pos, InteractionHand hand) {
        if (!player.getAbilities().instabuild) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, itemStack);
            }
            blockState.getBlock().setPlacedBy(level, pos, blockState, (LivingEntity)player, itemStack);
            if (hand == InteractionHand.MAIN_HAND) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            } else {
                itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
            }
            if (itemStack.isEmpty()) {
                ItemStack itemStack2 = new ItemStack((ItemLike)Items.BRUSH);
                itemStack2.set(DataComponents.CUSTOM_NAME, (Object)((Component)itemStack.getComponents().get(DataComponents.CUSTOM_NAME)));
                player.setItemInHand(hand, itemStack2);
            }
        }
    }

    public static void paintbrushItemEvents(Level level, BlockState state, BlockPos pos, Player player, ItemStack itemStack, InteractionHand hand) {
        level.playSound(null, pos, ACSounds.PAINT_WITH_PAINTBRUSH.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
        player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
        PaintbrushUtils.damagePaintbrushWhenPainting(level, player, itemStack, state, pos, hand);
    }

    public static void paintBlock(Level level, BlockState blockStateToPlace, BlockPos pos, Player player, ItemStack itemStack, InteractionHand hand) {
        BlockState blockState = level.getBlockState(pos);
        level.setBlockAndUpdate(pos, blockStateToPlace.getBlock().withPropertiesOf(blockState));
        PaintbrushUtils.paintbrushItemEvents(level, blockState, pos, player, itemStack, hand);
    }

    public static void paintBed(Level level, BlockState blockStateToPlace, BlockPos pos, Player player, ItemStack itemStack, InteractionHand hand) {
        BlockState blockState = level.getBlockState(pos);
        if (blockState.getValue((Property)BlockStateProperties.BED_PART) == BedPart.FOOT) {
            level.setBlockAndUpdate(pos.relative((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)), Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)blockStateToPlace.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT)).setValue((Property)BlockStateProperties.OCCUPIED, (Comparable)((Boolean)blockState.getValue((Property)BlockStateProperties.OCCUPIED))));
            level.setBlockAndUpdate(pos.relative((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)), (BlockState)((BlockState)((BlockState)blockStateToPlace.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD)).setValue((Property)BlockStateProperties.OCCUPIED, (Comparable)((Boolean)blockState.getValue((Property)BlockStateProperties.OCCUPIED))));
        } else {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)blockStateToPlace.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD)).setValue((Property)BlockStateProperties.OCCUPIED, (Comparable)((Boolean)blockState.getValue((Property)BlockStateProperties.OCCUPIED))));
            level.setBlockAndUpdate(pos.relative((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), -1), (BlockState)((BlockState)((BlockState)blockStateToPlace.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT)).setValue((Property)BlockStateProperties.OCCUPIED, (Comparable)((Boolean)blockState.getValue((Property)BlockStateProperties.OCCUPIED))));
        }
        if (hand == InteractionHand.MAIN_HAND) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        } else {
            itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
        }
        level.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
    }
}

