/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.item;

import com.kekecreations.arts_and_crafts.common.block.LotusFlowerBlock;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class LotusPistilItem
extends Item {
    public LotusPistilItem(Item.Properties $$0) {
        super($$0);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        BlockHitResult blockHitResult = LotusPistilItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockHitResult blockHitResult2 = blockHitResult.withPosition(blockHitResult.getBlockPos().above());
        InteractionResult interactionResult = this.place(level, player, blockHitResult, blockHitResult2, player.getItemInHand(interactionHand));
        return new InteractionResultHolder(interactionResult, (Object)player.getItemInHand(interactionHand));
    }

    public InteractionResult place(Level level, Player player, BlockHitResult fluidResult, BlockHitResult hitResult, ItemStack itemStack) {
        BlockState state;
        BlockPos pos = hitResult.getBlockPos();
        BlockPos fluidPos = fluidResult.getBlockPos();
        RandomSource randomSource = level.getRandom();
        BlockState clickedState = level.getBlockState(pos);
        if (level.getFluidState(fluidPos).is((Fluid)Fluids.WATER) && (state = this.getStateForPlacement(player)) != null) {
            level.setBlockAndUpdate(pos, state);
            level.playSound(null, pos, SoundEvents.LILY_PAD_PLACE, SoundSource.BLOCKS, 0.5f, randomSource.nextFloat() * 0.2f + 0.9f);
            level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)clickedState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, itemStack);
            }
            clickedState.getBlock().setPlacedBy(level, pos, clickedState, (LivingEntity)player, itemStack);
            if (!player.getAbilities().instabuild) {
                itemStack.setCount(itemStack.getCount() - 1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState getStateForPlacement(Player player) {
        return (BlockState)((BlockState)((BlockState)((BlockState)ACBlocks.LOTUS_FLOWER.get().getStateDefinition().any()).setValue((Property)LotusFlowerBlock.SHEARED, (Comparable)Boolean.valueOf(false))).setValue((Property)LotusFlowerBlock.AGE, (Comparable)Integer.valueOf(0))).setValue((Property)LotusFlowerBlock.FACING, (Comparable)player.getDirection().getOpposite());
    }
}

