/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.entity;

import com.kekecreations.arts_and_crafts.common.entity.ACBoat;
import com.kekecreations.arts_and_crafts.common.entity.ACBoatAccessor;
import com.kekecreations.arts_and_crafts.core.registry.ACEntityTypes;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ACChestBoat
extends ChestBoat
implements ACBoatAccessor {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private static final EntityDataAccessor<Integer> DATA_ID_BOAT_WOOD_TYPE = SynchedEntityData.defineId(ACChestBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ACChestBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public ACChestBoat(Level level, double x, double y, double z) {
        this(ACEntityTypes.CHEST_BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_BOAT_WOOD_TYPE, (Object)ACBoat.WoodType.OAK.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("wood_type", this.getBoatWoodType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("wood_type", 8)) {
            this.entityData.set(DATA_ID_BOAT_WOOD_TYPE, (Object)ACBoat.WoodType.byName(nbt.getString("wood_type")).ordinal());
        }
    }

    public Item getDropItem() {
        return switch (ACBoat.WoodType.byId((Integer)this.entityData.get(DATA_ID_BOAT_WOOD_TYPE))) {
            default -> throw new MatchException(null, null);
            case ACBoat.WoodType.OAK -> Items.OAK_CHEST_BOAT;
            case ACBoat.WoodType.CORK -> ACItems.CORK_CHEST_BOAT.get();
        };
    }

    @Override
    public void setBoatWoodType(ACBoat.WoodType type) {
        this.entityData.set(DATA_ID_BOAT_WOOD_TYPE, (Object)type.ordinal());
    }

    @Override
    public ACBoat.WoodType getBoatWoodType() {
        return ACBoat.WoodType.byId((Integer)this.entityData.get(DATA_ID_BOAT_WOOD_TYPE));
    }
}

