/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.common.item.PaintbrushItem;
import com.kekecreations.arts_and_crafts.common.util.PaintbrushUtils;
import com.kekecreations.arts_and_crafts.core.platform.Services;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ACFlowerPotBlock
extends Block {
    public static final HashMap<DyeColor, HashMap<Block, Block>> POTTED_MAPS = new HashMap();
    private final Block content;
    private final DyeColor colour;
    public static final float AABB_SIZE = 3.0f;
    protected static final VoxelShape SHAPE;

    public ACFlowerPotBlock(Block block, DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.content = block;
        this.colour = dyeColor;
        POTTED_MAPS.get(this.colour).put(block, this);
    }

    public boolean isEnabled(FeatureFlagSet $$0) {
        return Services.CONFIG.areDyedFlowerPotsEnabled();
    }

    private boolean isEmpty() {
        return this.content == Blocks.AIR;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        Block finalBlock;
        Item item = itemStack.getItem();
        Block block = Blocks.AIR;
        if (item instanceof BlockItem) {
            Block block2 = block = item instanceof BlockItem ? POTTED_MAPS.get(this.colour).getOrDefault(((BlockItem)item).getBlock(), Blocks.AIR) : Blocks.AIR;
        }
        if (!level.isClientSide() && itemStack.getItem() instanceof PaintbrushItem && (finalBlock = PaintbrushUtils.getFinalBlock(level.registryAccess(), blockState, itemStack)) != null && finalBlock != blockState.getBlock()) {
            PaintbrushUtils.paintBlock(level, finalBlock.defaultBlockState(), blockPos, player, itemStack, interactionHand);
            return ItemInteractionResult.SUCCESS;
        }
        BlockState blockState2 = block.defaultBlockState();
        if (blockState2.isAir()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.isEmpty()) {
            return ItemInteractionResult.CONSUME;
        }
        level.setBlock(blockPos, blockState2, 3);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
        player.awardStat(Stats.POT_FLOWER);
        itemStack.consume(1, (LivingEntity)player);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (this.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        ItemStack itemStack = new ItemStack((ItemLike)this.content);
        if (!player.addItem(itemStack)) {
            player.drop(itemStack, false);
        }
        level.setBlock(blockPos, ACBlocks.getDyedFlowerPot(this.colour.getId()).defaultBlockState(), 3);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (this.isEmpty()) {
            return super.getCloneItemStack(levelReader, blockPos, blockState);
        }
        return new ItemStack((ItemLike)this.content);
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public Block getContent() {
        return this.content;
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    static {
        for (DyeColor colour : DyeColor.values()) {
            POTTED_MAPS.put(colour, new HashMap());
        }
        SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    }
}

