/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.item.ArtifactItem;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EverlastingFoodItem
extends ArtifactItem {
    private final Supplier<Integer> eatingCooldown;
    private final Supplier<Boolean> isEnabled;

    public EverlastingFoodItem(FoodProperties food, Supplier<Integer> eatingCooldown, Supplier<Boolean> isEnabled) {
        super(new Item.Properties().food(food));
        this.eatingCooldown = eatingCooldown;
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean isCosmetic() {
        return this.isEnabled.get() == false;
    }

    @Override
    protected String getTooltipItemName() {
        return "everlasting_food";
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (stack.has(DataComponents.FOOD)) {
            entity.eat(world, stack.copy());
            if (this.eatingCooldown.get() > 0 && !entity.level().isClientSide() && entity instanceof Player) {
                Player player = (Player)entity;
                player.getCooldowns().addCooldown((Item)this, this.eatingCooldown.get() * 20);
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!this.isEnabled.get().booleanValue()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }
}

