/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.trinkets;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.client.item.renderer.GloveArtifactRenderer;
import artifacts.equipment.client.EquipmentRenderingHandler;
import artifacts.item.WearableArtifactItem;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TrinketsRenderingHandler
implements EquipmentRenderingHandler {
    @Override
    public void registerArtifactRenderer(Item item, Supplier<ArtifactRenderer> rendererSupplier) {
        TrinketRendererRegistry.registerRenderer((Item)item, (TrinketRenderer)new ArtifactTrinketRenderer((Supplier<ArtifactRenderer>)Suppliers.memoize(rendererSupplier::get)));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(Item item) {
        Object t;
        Optional renderer = TrinketRendererRegistry.getRenderer((Item)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactTrinketRenderer) {
            ArtifactTrinketRenderer artifactTrinketRenderer = (ArtifactTrinketRenderer)t;
            return artifactTrinketRenderer.renderer().get();
        }
        return null;
    }

    @Override
    public void renderArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side) {
        String groupId = side == player.getMainArm() ? "hand" : "offhand";
        TrinketsApi.getTrinketComponent((LivingEntity)player).ifPresent(component -> {
            for (Tuple pair : component.getAllEquipped()) {
                GloveArtifactRenderer gloveRenderer;
                ItemStack stack = (ItemStack)pair.getB();
                if (!((SlotReference)pair.getA()).inventory().getSlotType().getGroup().equals(groupId) || !(stack.getItem() instanceof WearableArtifactItem) || (gloveRenderer = GloveArtifactRenderer.getGloveRenderer(stack)) == null) continue;
                gloveRenderer.renderFirstPersonArm(matrixStack, buffer, light, player, side, stack.hasFoil());
            }
        });
    }

    public record ArtifactTrinketRenderer(Supplier<ArtifactRenderer> renderer) implements TrinketRenderer
    {
        public void render(ItemStack stack, SlotReference slotReference, EntityModel<? extends LivingEntity> entityModel, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            int index = slotReference.index() + (slotReference.inventory().getSlotType().getGroup().equals("hand") ? 0 : 1);
            this.renderer.get().renderVisible(stack, entity, index, poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

