/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.TickingAbility;
import artifacts.component.ability.mobeffect.PostEatingEffects;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.network.PlaySoundAtPlayerPacket;
import artifacts.registry.ModTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;

public record ReplenishHungerOnGrass(Value<Boolean> enabled, Value<Integer> replenishingDuration) implements EquipmentAbility,
TickingAbility
{
    public static final Codec<ReplenishHungerOnGrass> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.enabledField().forGetter(ReplenishHungerOnGrass::enabled), (App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(ReplenishHungerOnGrass::replenishingDuration)).apply((Applicative)instance, ReplenishHungerOnGrass::new));
    public static final StreamCodec<ByteBuf, ReplenishHungerOnGrass> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), ReplenishHungerOnGrass::enabled, ValueTypes.DURATION.streamCodec(), ReplenishHungerOnGrass::replenishingDuration, ReplenishHungerOnGrass::new);

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    @Override
    public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isDisabled) {
        ServerPlayer player;
        if (!isDisabled && !isOnCooldown && this.isNonCosmetic() && entity instanceof ServerPlayer && (player = (ServerPlayer)entity).onGround() && player.getFoodData().needsFood() && entity.tickCount % (Math.max(1, (Integer)this.replenishingDuration().get()) * 20) == 0 && entity.getBlockStateOn().is(ModTags.ROOTED_BOOTS_GRASS)) {
            player.getFoodData().eat(1, 0.5f);
            PostEatingEffects.applyEffects(entity, 1);
            PlaySoundAtPlayerPacket.sendSound(player, (Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.GENERIC_EAT), 0.5f, 0.8f + entity.getRandom().nextFloat() * 0.4f);
        }
    }
}

