/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.press;

import appeng.recipes.AERecipeTypes;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.Config;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.Nullable;

public class AE2CircuitPrintingProcesser
extends Processor<RecipeInput, InscriberRecipe> {
    public AE2CircuitPrintingProcesser(MinecraftServer server) {
        super(server, AERecipeTypes.INSCRIBER);
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.pressRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(InscriberRecipe recipe) {
        if (recipe.getProcessType() != InscriberProcessType.INSCRIBE) {
            return null;
        }
        Ingredient maybePress = recipe.getTopOptional();
        if (maybePress.isEmpty()) {
            return null;
        }
        if (!recipe.getBottomOptional().isEmpty()) {
            return null;
        }
        ItemStack[] presses = maybePress.getItems();
        if (presses.length != 1) {
            return null;
        }
        ItemStack press = presses[0];
        String id = BuiltInRegistries.ITEM.getKey((Object)press.getItem()).toString();
        if (!((List)Config.CONFIG.PRESS_AE2_INSCRIBER_CIRCUIT_PRINTING_PRESSES.get()).contains(id)) {
            return null;
        }
        Ingredient resource = recipe.getMiddleInput();
        if (resource.isEmpty()) {
            return null;
        }
        if (recipe.getResultItem().is(press.getItem())) {
            return null;
        }
        return resource;
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends InscriberRecipe> recipeHolder, Ingredient ingredient) {
        return new RecipeWrapper.Press(recipeHolder.id(), ingredient).withItems(((InscriberRecipe)recipeHolder.value()).getResultItem().copy()).asHolder();
    }
}

