/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.crush;

import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class ActuallyAdditionsCrusherProcessor
extends Processor<RecipeInput, CrushingRecipe> {
    public ActuallyAdditionsCrusherProcessor(MinecraftServer server) {
        super(server, (RecipeType)ActuallyRecipes.Types.CRUSHING.get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.crushRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(CrushingRecipe recipe) {
        return recipe.getInput();
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends CrushingRecipe> recipeHolder, Ingredient ingredient) {
        CrushingRecipe recipe = (CrushingRecipe)recipeHolder.value();
        RecipeWrapper.Crush wrapper = new RecipeWrapper.Crush(recipeHolder.id(), ingredient).withItems(recipe.getOutputOne(), recipe.getFirstChance()).withItems(recipe.getOutputTwo(), recipe.getSecondChance());
        return wrapper.asHolder();
    }
}

