/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.client.jei;

import alexthw.not_enough_glyphs.common.glyphs.effects.EffectFlatten;
import dev.qther.ars_unification.client.jei.JeiArsUnificationPlugin;
import dev.qther.ars_unification.recipe.PressRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class PressRecipeCategory
implements IRecipeCategory<RecipeHolder<PressRecipe>> {
    public IDrawable background;
    public IDrawable icon;
    private final IDrawable cachedArrows;

    public PressRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(this.getWidth(), this.getHeight());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)EffectFlatten.INSTANCE.glyphItem.getDefaultInstance());
        this.cachedArrows = helper.createAnimatedRecipeArrow(40);
    }

    @NotNull
    public RecipeType<RecipeHolder<PressRecipe>> getRecipeType() {
        return JeiArsUnificationPlugin.PRESS_RECIPE_TYPE.get();
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"ars_unification.press_recipe");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 56;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(RecipeHolder<PressRecipe> holder, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics matrixStack, double mouseX, double mouseY) {
        PressRecipe recipe = (PressRecipe)holder.value();
        this.cachedArrows.draw(matrixStack, 22, 6);
        Font renderer = Minecraft.getInstance().font;
        for (int i = 0; i < recipe.outputs().size(); ++i) {
            PressRecipe.PressOutput output = recipe.outputs().get(i);
            matrixStack.drawString(renderer, Math.round(100.0f * output.chance() - 0.5f) + "%", 98, 11 + 17 * i, 10, false);
            if (output.maxRange() <= 1) continue;
            matrixStack.drawString(renderer, "1-" + output.maxRange(), 75, 11 + 17 * i, 10, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<PressRecipe> holder, @NotNull IFocusGroup focuses) {
        PressRecipe recipe = (PressRecipe)holder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).addIngredients(recipe.input());
        for (int i = 0; i < recipe.outputs().size(); ++i) {
            PressRecipe.PressOutput output = recipe.outputs().get(i);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 5 + 16 * i).addItemStack(output.stack());
        }
    }
}

