/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.client.jei;

import com.google.common.base.Suppliers;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.client.jei.CutRecipeCategory;
import dev.qther.ars_unification.client.jei.JeiNegCompat;
import dev.qther.ars_unification.client.jei.PressRecipeCategory;
import dev.qther.ars_unification.recipe.CutRecipe;
import dev.qther.ars_unification.recipe.PressRecipe;
import dev.qther.ars_unification.setup.registry.AURecipeRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JeiArsUnificationPlugin
implements IModPlugin {
    public static final Supplier<RecipeType<RecipeHolder<CutRecipe>>> CUT_RECIPE_TYPE = JeiArsUnificationPlugin.type(AURecipeRegistry.CUT_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<PressRecipe>>> PRESS_RECIPE_TYPE = JeiArsUnificationPlugin.type(AURecipeRegistry.PRESS_TYPE);

    private static <R extends Recipe<?>> Supplier<RecipeType<RecipeHolder<R>>> type(Supplier<? extends net.minecraft.world.item.crafting.RecipeType<R>> ty) {
        return Suppliers.memoize(() -> RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ty.get())));
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ArsUnification.prefix("main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper gui = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CutRecipeCategory(gui), new PressRecipeCategory(gui)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        ArrayList<RecipeHolder> cutRecipes = new ArrayList<RecipeHolder>();
        ArrayList<RecipeHolder> pressRecipes = new ArrayList<RecipeHolder>();
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        for (RecipeHolder recipe : manager.getRecipes()) {
            Recipe recipe2;
            Objects.requireNonNull(recipe.value());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CutRecipe.class, PressRecipe.class}, (Object)recipe2, n)) {
                case 0: {
                    CutRecipe cutRecipe = (CutRecipe)recipe2;
                    cutRecipes.add(recipe);
                    break;
                }
                case 1: {
                    PressRecipe pressRecipe = (PressRecipe)recipe2;
                    pressRecipes.add(recipe);
                    break;
                }
            }
        }
        registry.addRecipes(CUT_RECIPE_TYPE.get(), cutRecipes);
        if (ModList.get().isLoaded("not_enough_glyphs")) {
            registry.addRecipes(PRESS_RECIPE_TYPE.get(), pressRecipes);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(ArsUnification.withAugmentTooltip((AbstractSpellPart)EffectCut.INSTANCE, (AbstractAugment)AugmentSensitive.INSTANCE), new RecipeType[]{CUT_RECIPE_TYPE.get()});
        if (ModList.get().isLoaded("not_enough_glyphs")) {
            JeiNegCompat.registerCategories(registry);
        }
    }
}

