/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CraftingHelpers {
    public static void setStairsShape(NonNullList<ItemStack> items, ItemStack itemStack) {
        items.set(0, (Object)itemStack.copy());
        items.set(3, (Object)itemStack.copy());
        items.set(4, (Object)itemStack.copy());
        items.set(6, (Object)itemStack.copy());
        items.set(7, (Object)itemStack.copy());
        items.set(8, (Object)itemStack.copy());
    }

    public static void setSlabShape(NonNullList<ItemStack> items, ItemStack itemStack) {
        items.set(0, (Object)itemStack.copy());
        items.set(1, (Object)itemStack.copy());
        items.set(2, (Object)itemStack.copy());
    }

    public static void setWallShape(NonNullList<ItemStack> items, ItemStack itemStack) {
        items.set(0, (Object)itemStack.copy());
        items.set(1, (Object)itemStack.copy());
        items.set(2, (Object)itemStack.copy());
        items.set(3, (Object)itemStack.copy());
        items.set(4, (Object)itemStack.copy());
        items.set(5, (Object)itemStack.copy());
    }

    public static void setSquareShape(NonNullList<ItemStack> items, ItemStack itemStack, int gridSize) {
        int itemCount = gridSize * gridSize;
        for (int i = 0; i < itemCount; ++i) {
            items.set(i, (Object)itemStack.copy());
        }
    }

    public static ItemStack getItem(CraftingInput container, Item item, Level world) {
        Optional<CraftingRecipe> recipe = world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)container, world).map(recipeHolder -> (CraftingRecipe)recipeHolder.value());
        return recipe.map(craftingRecipe -> craftingRecipe.assemble((RecipeInput)container, (HolderLookup.Provider)world.registryAccess())).orElse(ItemStack.EMPTY);
    }
}

