/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.glyphs.AbstractItemResolveEffect;
import com.zeroregard.ars_technica.helpers.RecipeHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class EffectApply
extends AbstractItemResolveEffect {
    public static EffectApply INSTANCE = new EffectApply(ArsTechnica.prefix("glyph_apply"), "Apply");

    private EffectApply(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockHitResult blockHit;
        BlockPos pos;
        if (rayTraceResult instanceof BlockHitResult && this.handleBlockApplication(pos = (blockHit = (BlockHitResult)rayTraceResult).getBlockPos(), blockHit, world, shooter, spellStats, spellContext, resolver)) {
            return;
        }
        super.onResolve(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    private boolean handleBlockApplication(BlockPos centerPos, BlockHitResult blockHitResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ApplyItemSource applySource = this.getApplyItemSource(shooter, world);
        if (applySource.isEmpty()) {
            return false;
        }
        double aoeBuff = spellStats.getAoeMultiplier();
        int pierceBuff = spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        List posList = SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)centerPos, (BlockHitResult)blockHitResult, (double)aoeBuff, (int)pierceBuff);
        int applicationsPerformed = 0;
        for (BlockPos pos : posList) {
            ItemStack result;
            ItemStack applyItem = applySource.getItem();
            if (applyItem.isEmpty()) break;
            BlockState targetBlock = world.getBlockState(pos);
            Optional<RecipeHolder<Recipe<RecipeInput>>> recipe = this.getApplicationRecipe(applyItem, targetBlock, world);
            if (recipe.isEmpty() || (result = recipe.get().value().getResultItem((HolderLookup.Provider)world.registryAccess())).isEmpty()) continue;
            applySource.consumeItem();
            Block resultBlock = Block.byItem((Item)result.getItem());
            if (resultBlock != null && !resultBlock.equals(Blocks.AIR)) {
                world.setBlock(pos, resultBlock.defaultBlockState(), 3);
            } else {
                ItemEntity resultEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, result.copy());
                world.addFreshEntity((Entity)resultEntity);
            }
            world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.8f, 1.0f + (world.random.nextFloat() - 0.5f) * 0.4f);
            ++applicationsPerformed;
        }
        return applicationsPerformed > 0;
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ApplyItemSource applySource = this.getApplyItemSource(shooter, world);
        if (applySource.isEmpty()) {
            return;
        }
        int aoeBuff = (int)Math.round(spellStats.getAoeMultiplier());
        int maxAmountToApply = 4 * (1 + aoeBuff);
        int totalApplied = 0;
        for (ItemEntity itemEntity : entityList) {
            if (totalApplied >= maxAmountToApply) break;
            ItemStack itemStack = itemEntity.getItem();
            ItemStack applyItem = applySource.getItem();
            if (applyItem.isEmpty()) break;
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            Optional<RecipeHolder<DeployerApplicationRecipe>> seqRecipe = RecipeHelpers.getSequencedAssemblyRecipe(AllRecipeTypes.DEPLOYING.getType(), DeployerApplicationRecipe.class, applyItem, itemStack, world);
            if (seqRecipe.isPresent()) {
                results.addAll(((DeployerApplicationRecipe)seqRecipe.get().value()).rollResults(world.getRandom()));
            } else {
                Optional<RecipeHolder<Recipe<RecipeInput>>> recipe = this.getApplicationRecipe(applyItem, itemStack, world);
                if (recipe.isPresent()) {
                    results.add(recipe.get().value().getResultItem((HolderLookup.Provider)world.registryAccess()));
                }
            }
            if (results.isEmpty()) continue;
            int remainingToApply = maxAmountToApply - totalApplied;
            int stackSize = itemStack.getCount();
            int applicationsToThisStack = Math.min(remainingToApply, stackSize);
            if ((applicationsToThisStack = Math.min(applicationsToThisStack, applySource.getAvailableCount())) <= 0) continue;
            applySource.consumeItems(applicationsToThisStack);
            itemStack.shrink(applicationsToThisStack);
            if (itemStack.getCount() <= 0) {
                itemEntity.discard();
            }
            for (int i = 0; i < applicationsToThisStack; ++i) {
                for (ItemStack result : results) {
                    ItemEntity resultEntity = new ItemEntity(world, itemEntity.getX() + (double)((world.random.nextFloat() - 0.5f) * 0.2f), itemEntity.getY(), itemEntity.getZ() + (double)((world.random.nextFloat() - 0.5f) * 0.2f), result.copy());
                    world.addFreshEntity((Entity)resultEntity);
                }
            }
            world.playSound(null, itemEntity.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.6f, 1.0f + (world.random.nextFloat() - 0.5f) * 0.4f);
            totalApplied += applicationsToThisStack;
            if (!applySource.isEmpty()) continue;
            break;
        }
    }

    private ApplyItemSource getApplyItemSource(@Nullable LivingEntity shooter, Level world) {
        if (shooter instanceof FakePlayer) {
            return new InventoryApplyItemSource(shooter, world);
        }
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            return new PlayerApplyItemSource(player);
        }
        return new EmptyApplyItemSource();
    }

    private Optional<RecipeHolder<Recipe<RecipeInput>>> getApplicationRecipe(ItemStack applyItem, ItemStack target, Level world) {
        Optional<RecipeHolder<Recipe<RecipeInput>>> recipe = RecipeHelpers.getItemApplicationRecipe(applyItem, target, world);
        if (recipe.isPresent()) {
            return recipe;
        }
        return RecipeHelpers.getDeployingRecipe(applyItem, target, world);
    }

    private Optional<RecipeHolder<Recipe<RecipeInput>>> getApplicationRecipe(ItemStack applyItem, BlockState target, Level world) {
        ItemStack targetItem = new ItemStack((ItemLike)target.getBlock().asItem());
        if (targetItem.isEmpty() || targetItem.getItem() == Items.AIR) {
            return Optional.empty();
        }
        return this.getApplicationRecipe(applyItem, targetItem, world);
    }

    public int getDefaultManaCost() {
        return 80;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the amount of items that can be applied to and the area of blocks affected");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Uses the item in your offhand to apply to blocks or items, such as applying andesite alloy to stripped logs to create casings. Also supports deploying items onto other items.";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }

    private static abstract class ApplyItemSource {
        private ApplyItemSource() {
        }

        public abstract ItemStack getItem();

        public abstract int getAvailableCount();

        public abstract void consumeItem();

        public abstract void consumeItems(int var1);

        public abstract boolean isEmpty();
    }

    private static class InventoryApplyItemSource
    extends ApplyItemSource {
        private Container foundContainer;
        private int foundSlot;

        public InventoryApplyItemSource(LivingEntity shooter, Level world) {
            this.findFirstAvailableItem(shooter, world);
        }

        private void findFirstAvailableItem(LivingEntity shooter, Level world) {
            BlockPos shooterPos = shooter.blockPosition();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos checkPos;
                        BlockEntity blockEntity;
                        if (dx == 0 && dy == 0 && dz == 0 || !((blockEntity = world.getBlockEntity(checkPos = shooterPos.offset(dx, dy, dz))) instanceof Container)) continue;
                        Container container = (Container)blockEntity;
                        for (int slot = 0; slot < container.getContainerSize(); ++slot) {
                            ItemStack item = container.getItem(slot);
                            if (item.isEmpty()) continue;
                            this.foundContainer = container;
                            this.foundSlot = slot;
                            return;
                        }
                    }
                }
            }
        }

        @Override
        public ItemStack getItem() {
            if (this.foundContainer != null) {
                return this.foundContainer.getItem(this.foundSlot);
            }
            return ItemStack.EMPTY;
        }

        @Override
        public int getAvailableCount() {
            if (this.foundContainer != null) {
                return this.foundContainer.getItem(this.foundSlot).getCount();
            }
            return 0;
        }

        @Override
        public void consumeItem() {
            if (this.foundContainer != null) {
                ItemStack item = this.foundContainer.getItem(this.foundSlot);
                item.shrink(1);
                if (item.isEmpty()) {
                    this.foundContainer.setItem(this.foundSlot, ItemStack.EMPTY);
                }
            }
        }

        @Override
        public void consumeItems(int count) {
            if (this.foundContainer != null) {
                ItemStack item = this.foundContainer.getItem(this.foundSlot);
                item.shrink(count);
                if (item.isEmpty()) {
                    this.foundContainer.setItem(this.foundSlot, ItemStack.EMPTY);
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return this.foundContainer == null || this.getItem().isEmpty();
        }
    }

    private static class PlayerApplyItemSource
    extends ApplyItemSource {
        private final Player player;

        public PlayerApplyItemSource(Player player) {
            this.player = player;
        }

        @Override
        public ItemStack getItem() {
            return this.player.getOffhandItem();
        }

        @Override
        public int getAvailableCount() {
            return this.player.getOffhandItem().getCount();
        }

        @Override
        public void consumeItem() {
            this.player.getOffhandItem().shrink(1);
        }

        @Override
        public void consumeItems(int count) {
            this.player.getOffhandItem().shrink(count);
        }

        @Override
        public boolean isEmpty() {
            return this.player.getOffhandItem().isEmpty();
        }
    }

    private static class EmptyApplyItemSource
    extends ApplyItemSource {
        private EmptyApplyItemSource() {
        }

        @Override
        public ItemStack getItem() {
            return ItemStack.EMPTY;
        }

        @Override
        public int getAvailableCount() {
            return 0;
        }

        @Override
        public void consumeItem() {
        }

        @Override
        public void consumeItems(int count) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

