/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity.fusion.fluids;

import com.zeroregard.ars_technica.helpers.FluidHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidSourceProvider {
    private final FluidStack fluidStack;
    private final BlockPos sourcePos;
    @Nullable
    private final FluidState fluidState;
    @Nullable
    private final IFluidHandler tankSource;

    public FluidSourceProvider(FluidStack fluidStack, @Nullable BlockPos sourcePos, IFluidHandler tankSource) {
        this.fluidStack = fluidStack;
        this.sourcePos = sourcePos;
        this.tankSource = tankSource;
        this.fluidState = null;
    }

    public FluidSourceProvider(FluidStack fluidStack, @Nullable BlockPos sourcePos, FluidState fluidState) {
        this.fluidStack = fluidStack;
        this.sourcePos = sourcePos;
        this.fluidState = fluidState;
        this.tankSource = null;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public int getMbAmount() {
        if (this.tankSource != null) {
            return this.tankSource.getFluidInTank(0).getAmount();
        }
        return this.fluidState.getAmount() * FluidHelper.FLUID_TO_MB_MULTIPLIER;
    }

    public void drainFluid(int mbToDrain, Level world) {
        if (this.tankSource != null) {
            this.tankSource.drain(mbToDrain, IFluidHandler.FluidAction.EXECUTE);
        } else if (this.fluidState != null) {
            int newAmount = this.fluidStack.getAmount() - mbToDrain / FluidHelper.FLUID_TO_MB_MULTIPLIER;
            this.fluidStack.setAmount(newAmount);
            if (newAmount == 0) {
                world.setBlock(this.sourcePos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }
}

