/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity.fusion;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.zeroregard.ars_technica.entity.Colorable;
import com.zeroregard.ars_technica.entity.fusion.AllArcaneFusionTypes;
import com.zeroregard.ars_technica.entity.fusion.ArcaneFusionParticles;
import com.zeroregard.ars_technica.entity.fusion.ArcaneFusionType;
import com.zeroregard.ars_technica.entity.fusion.fluids.ArcaneFusionFluids;
import com.zeroregard.ars_technica.entity.fusion.fluids.FluidSourceProvider;
import com.zeroregard.ars_technica.helpers.FluidHelper;
import com.zeroregard.ars_technica.helpers.MixingRecipeHelpers;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import com.zeroregard.ars_technica.registry.SoundRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.Color;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcaneFusionEntity
extends Entity
implements GeoEntity,
Colorable {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.defineId(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private ArcaneFusionType fusionType;
    private final ArcaneFusionParticles particleHandler;
    private final ArcaneFusionFluids fluidHandler;
    private long createdTime;
    private float elapsedTime;
    private int tickCount = 0;
    private boolean impacted = false;
    private boolean swung = false;
    private boolean failed = false;
    private static final EntityDataAccessor<Boolean> FAILED = SynchedEntityData.defineId(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> INGREDIENT_A = SynchedEntityData.defineId(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> INGREDIENT_B = SynchedEntityData.defineId(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> INGREDIENT_C = SynchedEntityData.defineId(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> INGREDIENT_D = SynchedEntityData.defineId(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private double aoe = 1.0;
    private Entity caster;
    private final Level world;
    private ItemEntity resultEntity;
    private List<FluidStack> resultLiquids;
    public static float CHARGE_TIME = 1.65f;
    public static float SWING_TIME = 0.35f;
    public static float IMPACT_TIME = CHARGE_TIME + SWING_TIME;
    public static float REMOVE_TIME = IMPACT_TIME + 1.0f;
    private AnimationController<ArcaneFusionEntity> animationController;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public boolean getImpacted() {
        return this.impacted;
    }

    public boolean getSwung() {
        return this.swung;
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public ArcaneFusionType getFusionType() {
        return this.fusionType;
    }

    public ArcaneFusionEntity(@Nullable Entity target, Vec3 position, Level world, Entity caster, Color color, SpellResolver resolver, SpellStats spellStats, String fusionTypeId) {
        super((EntityType)EntityRegistry.ARCANE_FUSION_ENTITY.get(), world);
        this.world = world;
        this.aoe = 1.0 + spellStats.getAoeMultiplier();
        this.caster = caster;
        this.setPos(position.x, position.y, position.z);
        this.createdTime = world.getGameTime();
        this.particleHandler = new ArcaneFusionParticles(this, world);
        this.fluidHandler = new ArcaneFusionFluids(this, world);
        this.entityData.set(TYPE, (Object)fusionTypeId);
        this.fusionType = AllArcaneFusionTypes.getTypeFromId(fusionTypeId);
    }

    public ArcaneFusionEntity(EntityType<ArcaneFusionEntity> entityType, Level world) {
        super(entityType, world);
        this.world = world;
        this.particleHandler = new ArcaneFusionParticles(this, world);
        this.fluidHandler = new ArcaneFusionFluids(this, world);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.createdTime = this.world.getGameTime();
        this.handleIngredients();
    }

    public void tick() {
        this.elapsedTime = (float)(this.world.getGameTime() - this.createdTime) / 20.0f;
        ++this.tickCount;
        if (this.elapsedTime > REMOVE_TIME) {
            this.discard();
        }
        if (this.world.isClientSide && this.fusionType != null) {
            this.particleHandler.handleParticles();
        }
        if (this.failed) {
            return;
        }
        if (this.elapsedTime > CHARGE_TIME && !this.swung) {
            this.playWorldSound((SoundEvent)SoundRegistry.FUSE_SWING.get(), 0.75f, 1.0f);
            this.swung = true;
        }
        if (this.elapsedTime > IMPACT_TIME && !this.impacted) {
            this.playWorldSound((SoundEvent)SoundRegistry.FUSE_IMPACT.get(), 0.75f, 1.0f);
            this.outputResults();
            this.impacted = true;
        }
    }

    private void playWorldSound(SoundEvent soundEvent, float volume, float pitch) {
        Vec3 pos = this.getPosition(1.0f);
        this.world.playSound(null, pos.x, pos.y, pos.z, soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    protected void outputResults() {
        if (this.resultEntity != null) {
            this.world.addFreshEntity((Entity)this.resultEntity);
        }
        if (this.resultLiquids != null) {
            for (FluidStack fluidStack : this.resultLiquids) {
                FluidHelper.dumpFluid(fluidStack, this.world, this.getPosition(1.0f), 4);
            }
        }
    }

    protected void handleIngredients() {
        if (this.world.isClientSide || this.fusionType == null) {
            return;
        }
        List<FluidSourceProvider> fluids = this.fluidHandler.pickupFluids();
        List itemEntities = this.world.getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(this.aoe));
        if (itemEntities.isEmpty() && fluids.isEmpty()) {
            this.onFailure("no nearby items/fluids were found");
            return;
        }
        this.tryCombineIngredients(itemEntities, fluids);
    }

    protected void tryCombineIngredients(List<ItemEntity> itemEntities, List<FluidSourceProvider> fluids) {
        Optional<MixingRecipeHelpers.MixingRecipeResult> result = MixingRecipeHelpers.getMixingRecipe(itemEntities, fluids, this.world, this.fusionType);
        if (result.isPresent()) {
            int maxFluidIterations;
            int recipeIterations;
            int n;
            MixingRecipeHelpers.MixingRecipeResult resultObj = result.get();
            MixingRecipe recipe = resultObj.recipe;
            List<ItemEntity> ingredients = resultObj.usedEntities;
            List<FluidSourceProvider> fluidIngredients = resultObj.usedFluids;
            int maxItemIterations = Integer.MAX_VALUE;
            if (!ingredients.isEmpty()) {
                HashMap<ItemEntity, Integer> usageMap = new HashMap<ItemEntity, Integer>();
                for (ItemEntity itemEntity2 : ingredients) {
                    usageMap.put(itemEntity2, usageMap.getOrDefault(itemEntity2, 0) + 1);
                }
                for (Map.Entry entry : usageMap.entrySet()) {
                    ItemEntity itemEntity2 = (ItemEntity)entry.getKey();
                    int usedCount = (Integer)entry.getValue();
                    int totalAvailable = itemEntity2.getItem().getCount();
                    int entityMaxIterations = totalAvailable / usedCount;
                    maxItemIterations = Math.min(maxItemIterations, entityMaxIterations);
                }
            }
            if ((n = Math.min(recipeIterations = Math.min(maxItemIterations, maxFluidIterations = recipe.getFluidIngredients().isEmpty() ? Integer.MAX_VALUE : fluidIngredients.stream().mapToInt(fluidSource -> {
                SizedFluidIngredient requiredFluidIngredient = recipe.getFluidIngredients().stream().filter(ingredient -> ingredient.ingredient().test(fluidSource.getFluidStack())).findFirst().orElse(null);
                if (requiredFluidIngredient == null) {
                    return 0;
                }
                return (int)Math.floor(fluidSource.getMbAmount() / requiredFluidIngredient.amount());
            }).min().orElse(0)), (int)Math.round(this.aoe * 4.0))) <= 0) {
                this.onFailure("there were not enough resources for a found recipe");
                return;
            }
            if (ingredients != null && !ingredients.isEmpty()) {
                this.particleHandler.setIngredientsForParticles(ingredients);
            }
            ingredients.forEach(itemEntity -> {
                ItemStack item = itemEntity.getItem();
                item.setCount(item.getCount() - clampedRecipeIterations);
                if (item.getCount() <= 0) {
                    itemEntity.discard();
                }
            });
            fluidIngredients.forEach(fluidSource -> {
                SizedFluidIngredient requiredFluidIngredient = recipe.getFluidIngredients().stream().filter(ingredient -> ingredient.ingredient().test(fluidSource.getFluidStack())).findFirst().orElse(null);
                if (requiredFluidIngredient != null) {
                    int mbToDrain = requiredFluidIngredient.amount() * clampedRecipeIterations;
                    fluidSource.drainFluid(mbToDrain, this.world);
                }
            });
            this.setItemResult(recipe, n);
            this.setFluidResult(recipe, n);
            this.playWorldSound((SoundEvent)SoundRegistry.FUSE_CHARGE.get(), 0.75f, 1.0f);
        } else {
            this.onFailure("no recipes were found for nearby items/fluids");
        }
    }

    private void onFailure(String failureReason) {
        this.failed = true;
        this.entityData.set(FAILED, (Object)true);
        this.playWorldSound((SoundEvent)SoundRegistry.FUSE_FAILED.get(), 0.75f, 1.0f);
    }

    private void setItemResult(MixingRecipe recipe, int recipeIterations) {
        RegistryAccess registryAccess = this.world.registryAccess();
        ItemStack recipeItemResult = recipe.getResultItem((HolderLookup.Provider)registryAccess);
        ItemStack itemOutput = recipeItemResult.copy();
        itemOutput.setCount(itemOutput.getCount() * recipeIterations);
        this.resultEntity = new ItemEntity(this.world, this.getX(), this.getY(), this.getZ(), itemOutput);
    }

    private void setFluidResult(MixingRecipe recipe, int recipeIterations) {
        NonNullList fluidResults = recipe.getFluidResults();
        this.resultLiquids = fluidResults.stream().map(fluidStack -> {
            int newAmount = fluidStack.getAmount() * recipeIterations;
            return new FluidStack(fluidStack.getFluid(), newAmount);
        }).collect(Collectors.toList());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        this.animationController = new AnimationController((GeoAnimatable)this, "fusionController", 0, this::fuseAnimationPredicate);
        controllerRegistrar.add(this.animationController);
    }

    private PlayState fuseAnimationPredicate(AnimationState<?> event) {
        if (this.failed) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("fail"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("charge"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void defineSynchedData(SynchedEntityData.Builder dataBuilder) {
        dataBuilder.define(TYPE, (Object)"");
        dataBuilder.define(FAILED, (Object)false);
        dataBuilder.define(INGREDIENT_A, (Object)"");
        dataBuilder.define(INGREDIENT_B, (Object)"");
        dataBuilder.define(INGREDIENT_C, (Object)"");
        dataBuilder.define(INGREDIENT_D, (Object)"");
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        this.particleHandler.onSyncedDataUpdated(key);
        if (TYPE.equals(key)) {
            String typeId = (String)this.entityData.get(TYPE);
            this.fusionType = AllArcaneFusionTypes.getTypeFromId(typeId);
        }
        if (FAILED.equals(key)) {
            this.failed = (Boolean)this.entityData.get(FAILED);
        }
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }

    @Override
    public Color getColor() {
        return Color.WHITE;
    }

    @Override
    public double getAlpha() {
        return 1.0;
    }
}

