/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ConsumptionHelper {
    public static boolean tryUseEdibleItem(LivingEntity consumer, ItemStack itemStack, Level world) {
        if (ConsumptionHelper.isDrink(itemStack)) {
            itemStack.finishUsingItem(world, consumer);
            ConsumptionHelper.playSound(SoundEvents.GENERIC_DRINK, world, consumer);
            return true;
        }
        if (ConsumptionHelper.isFood(itemStack, consumer)) {
            consumer.eat(world, itemStack);
            ConsumptionHelper.playSound(SoundEvents.GENERIC_EAT, world, consumer);
            return true;
        }
        return false;
    }

    public static boolean isDrink(ItemStack stack) {
        return stack.getItem() instanceof PotionItem || stack.getUseAnimation() == UseAnim.DRINK;
    }

    public static boolean isFood(ItemStack stack, @Nullable LivingEntity consumer) {
        return stack.getItem().getFoodProperties(stack, consumer) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryUseConsumableItem(LivingEntity consumer, ItemStack itemStack, Level world, boolean allowedToUse) {
        if (!allowedToUse) {
            return false;
        }
        if (consumer instanceof Player) {
            Player player = (Player)consumer;
            InteractionHand temporaryHand = InteractionHand.MAIN_HAND;
            ItemStack originalItem = player.getItemInHand(temporaryHand);
            try {
                player.setItemInHand(temporaryHand, itemStack);
                if (ConsumptionHelper.isDrink(itemStack)) {
                    itemStack.finishUsingItem(world, (LivingEntity)player);
                    ConsumptionHelper.playSound(SoundEvents.GENERIC_DRINK, world, consumer);
                    boolean bl = true;
                    return bl;
                }
                InteractionResult result = itemStack.use(world, player, temporaryHand).getResult();
                if (result == InteractionResult.CONSUME) {
                    ConsumptionHelper.playSound(SoundEvents.GENERIC_EAT, world, consumer);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                player.setItemInHand(temporaryHand, originalItem);
            }
            return false;
        }
        return false;
    }

    public static void playSound(SoundEvent event, Level world, LivingEntity consumer) {
        world.playSound(null, consumer.getX(), consumer.getY(), consumer.getZ(), event, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

