/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.RuneCaster;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFlare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.logistics.depot.DepotBlock;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.entity.ArcaneWhirlEntity;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EffectWhirl
extends AbstractEffect {
    public static EffectWhirl INSTANCE = new EffectWhirl(ArsTechnica.prefix("glyph_whirl"), "Whirl");
    public final float DEFAULT_RADIUS = 1.5f;
    public final int DEFAULT_DURATION = 360;

    private EffectWhirl(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Vec3 position = rayTraceResult.getLocation();
        IWrappedCaster iWrappedCaster = spellContext.getCaster();
        if (iWrappedCaster instanceof RuneCaster) {
            RuneCaster runeCaster = (RuneCaster)iWrappedCaster;
            Vec3 casterPos = runeCaster.getPosition();
            position = casterPos.add(0.5, 0.0, 0.5);
        }
        this.resolve(position, (Level)serverWorld, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockPos blockPos = rayTraceResult.getBlockPos();
        BlockState state = world.getBlockState(blockPos);
        boolean boundToDepot = false;
        if (state.getBlock() instanceof DepotBlock) {
            boundToDepot = true;
        }
        Vec3 adjustedPosition = boundToDepot ? Vec3.atCenterOf((Vec3i)blockPos).add(0.0, 0.5, 0.0) : this.getAdjustedPosition(rayTraceResult);
        ArcaneWhirlEntity whirl = this.resolve(adjustedPosition, (Level)serverWorld, shooter, spellStats, spellContext, resolver);
        if (boundToDepot && whirl != null) {
            whirl.bindDepot(blockPos);
        }
    }

    private Vec3 getAdjustedPosition(BlockHitResult rayTraceResult) {
        BlockPos blockPos = rayTraceResult.getBlockPos();
        Direction hitFace = rayTraceResult.getDirection();
        Vec3 center = Vec3.atCenterOf((Vec3i)blockPos);
        switch (hitFace) {
            case UP: {
                return center.add(0.0, 0.5, 0.0);
            }
            case DOWN: {
                return center.add(0.0, -1.0, 0.0);
            }
            case NORTH: {
                return center.add(0.0, 0.0, -1.0);
            }
            case SOUTH: {
                return center.add(0.0, 0.0, 1.0);
            }
            case WEST: {
                return center.add(-1.0, 0.0, 0.0);
            }
            case EAST: {
                return center.add(1.0, 0.0, 0.0);
            }
        }
        return center;
    }

    protected ArcaneWhirlEntity resolve(Vec3 position, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        float aoeAmplifier = (float)spellStats.getAoeMultiplier();
        double durationAmplifier = spellStats.getDurationMultiplier();
        int extraDurationTicks = Math.toIntExact(Math.round(durationAmplifier * 40.0));
        AllFanProcessingTypes.SplashingType processingType = null;
        if (spellContext.hasNextPart()) {
            while (spellContext.hasNextPart()) {
                AbstractSpellPart next = spellContext.nextPart();
                if (!(next instanceof AbstractEffect)) continue;
                if (next == EffectConjureWater.INSTANCE) {
                    processingType = AllFanProcessingTypes.SPLASHING;
                    break;
                }
                if (next == EffectFlare.INSTANCE) {
                    processingType = AllFanProcessingTypes.SMOKING;
                    break;
                }
                if (next == EffectSmelt.INSTANCE) {
                    processingType = AllFanProcessingTypes.BLASTING;
                    break;
                }
                if (next != EffectHex.INSTANCE) break;
                processingType = AllFanProcessingTypes.HAUNTING;
                break;
            }
        }
        ArcaneWhirlEntity whirl = new ArcaneWhirlEntity(world, position, 1.5f + aoeAmplifier * 0.33f, 360 + extraDurationTicks, (FanProcessingType)processingType, resolver);
        world.addFreshEntity((Entity)whirl);
        return whirl;
    }

    public int getDefaultManaCost() {
        return 40;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the size and the range of items being processed");
        map.put((AbstractAugment)AugmentExtendTime.INSTANCE, "Increases the duration of processing");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentExtendTime.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_AIR});
    }

    public String getBookDescription() {
        return "Creates a whirlwind in an area, causing items to be centrifuged.";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }
}

