/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.glyphs.AbstractItemResolveEffect;
import com.zeroregard.ars_technica.helpers.CraftingHelpers;
import com.zeroregard.ars_technica.helpers.ItemHelpers;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EffectPack
extends AbstractItemResolveEffect {
    public static EffectPack INSTANCE = new EffectPack(ArsTechnica.prefix("glyph_pack"), "Pack");

    private EffectPack(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double amplifier = spellStats.getAmpMultiplier();
        Map<Item, List<ItemEntity>> groupedItems = entityList.stream().collect(Collectors.groupingBy(itemEntity -> itemEntity.getItem().getItem()));
        Map<Item, List> packableItems = groupedItems.entrySet().stream().filter(entry -> this.isPackable((Item)entry.getKey(), world, amplifier)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<Item, List> entry2 : packableItems.entrySet()) {
            this.packItems(entry2.getKey(), entry2.getValue(), spellStats, world, pos, amplifier);
        }
    }

    private boolean isPackable(Item item, Level world, double amplifier) {
        int packGridSize = this.getPackGridSize(amplifier);
        return this.hasCraftingRecipe(item, packGridSize, world);
    }

    private boolean hasCraftingRecipe(Item item, int gridSize, Level world) {
        NonNullList mutableItems = NonNullList.withSize((int)(gridSize * gridSize), (Object)ItemStack.EMPTY);
        ItemStack itemStack = new ItemStack((ItemLike)item, 1);
        for (int i = 0; i < gridSize * gridSize; ++i) {
            mutableItems.set(i, (Object)itemStack.copy());
        }
        CraftingInput tempContainer = CraftingInput.of((int)gridSize, (int)gridSize, (List)mutableItems);
        Optional<CraftingRecipe> recipe = world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)tempContainer, world).map(RecipeHolder::value);
        return recipe.isPresent();
    }

    private int getPackGridSize(double amplifier) {
        int value = (int)amplifier + 2;
        value = Math.max(value, 1);
        value = Math.min(value, 3);
        return value;
    }

    private void packItems(Item item, List<ItemEntity> itemEntities, SpellStats spellStats, Level world, BlockPos pos, double amplifier) {
        int gridSize = this.getPackGridSize(amplifier);
        int packSize = gridSize * gridSize;
        int totalItemCount = itemEntities.stream().mapToInt(entity -> entity.getItem().getCount()).sum();
        int totalPacks = totalItemCount / packSize;
        NonNullList mutableItems = NonNullList.withSize((int)(gridSize * gridSize), (Object)ItemStack.EMPTY);
        CraftingHelpers.setSquareShape((NonNullList<ItemStack>)mutableItems, new ItemStack((ItemLike)item, 1), gridSize);
        CraftingInput container = CraftingInput.of((int)gridSize, (int)gridSize, List.copyOf(mutableItems));
        for (int i = 0; i < totalPacks; ++i) {
            ItemStack packedItem = CraftingHelpers.getItem(container, item, world);
            if (packedItem.isEmpty()) continue;
            ItemHelpers.createItemEntity(packedItem, world, pos);
        }
        int totalItemsToRemove = totalPacks * packSize;
        ItemHelpers.subtractItemsFromItemEntities(itemEntities, totalItemsToRemove, item, pos, world);
    }

    public int getDefaultManaCost() {
        return 10;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAmplify.INSTANCE, "Changes recipe grid size to 3x3");
        map.put((AbstractAugment)AugmentDampen.INSTANCE, "Changes recipe grid size to 1x1");
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the area in which items get collected for processing");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentAOE.INSTANCE, AugmentDampen.INSTANCE});
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentDampen.INSTANCE.getRegistryName(), 1);
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Condenses identical items, crafting them into 2x2 recipes.";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }
}

