/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util.bkd;

import java.util.function.IntFunction;
import org.apache.lucene.ars_nouveau.util.bkd.PointReader;
import org.apache.lucene.ars_nouveau.util.bkd.PointValue;

public final class HeapPointReader
implements PointReader {
    private int curRead;
    private final int end;
    private final IntFunction<PointValue> points;

    HeapPointReader(IntFunction<PointValue> points, int start, int end) {
        this.curRead = start - 1;
        this.end = end;
        this.points = points;
    }

    @Override
    public boolean next() {
        ++this.curRead;
        return this.curRead < this.end;
    }

    @Override
    public PointValue pointValue() {
        return this.points.apply(this.curRead);
    }

    @Override
    public void close() {
    }
}

