/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.util.Comparator;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.BytesRefComparator;
import org.apache.lucene.ars_nouveau.util.Sorter;
import org.apache.lucene.ars_nouveau.util.StableMSBRadixSorter;
import org.apache.lucene.ars_nouveau.util.StringSorter;

abstract class StableStringSorter
extends StringSorter {
    StableStringSorter(Comparator<BytesRef> cmp) {
        super(cmp);
    }

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    @Override
    protected Sorter radixSorter(final BytesRefComparator cmp) {
        return new StableMSBRadixSorter(cmp.comparedBytesCount){

            @Override
            protected void save(int i, int j) {
                StableStringSorter.this.save(i, j);
            }

            @Override
            protected void restore(int i, int j) {
                StableStringSorter.this.restore(i, j);
            }

            @Override
            protected void swap(int i, int j) {
                StableStringSorter.this.swap(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                StableStringSorter.this.get(StableStringSorter.this.scratch1, StableStringSorter.this.scratchBytes1, i);
                return cmp.byteAt(StableStringSorter.this.scratchBytes1, k);
            }

            @Override
            protected Sorter getFallbackSorter(int k) {
                return StableStringSorter.this.fallbackSorter((o1, o2) -> cmp.compare((BytesRef)o1, (BytesRef)o2, k));
            }
        };
    }

    @Override
    protected Sorter fallbackSorter(final Comparator<BytesRef> cmp) {
        return new StableMSBRadixSorter.MergeSorter(){

            @Override
            protected void save(int i, int j) {
                StableStringSorter.this.save(i, j);
            }

            @Override
            protected void restore(int i, int j) {
                StableStringSorter.this.restore(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                StableStringSorter.this.get(StableStringSorter.this.scratch1, StableStringSorter.this.scratchBytes1, i);
                StableStringSorter.this.get(StableStringSorter.this.scratch2, StableStringSorter.this.scratchBytes2, j);
                return cmp.compare(StableStringSorter.this.scratchBytes1, StableStringSorter.this.scratchBytes2);
            }

            @Override
            protected void swap(int i, int j) {
                StableStringSorter.this.swap(i, j);
            }
        };
    }
}

