/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.store;

import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.store.FlushInfo;
import org.apache.lucene.ars_nouveau.store.MergeInfo;
import org.apache.lucene.ars_nouveau.store.ReadAdvice;
import org.apache.lucene.ars_nouveau.util.Constants;

public record IOContext(Context context, MergeInfo mergeInfo, FlushInfo flushInfo, ReadAdvice readAdvice) {
    public static final IOContext DEFAULT = new IOContext(Constants.DEFAULT_READADVICE);
    public static final IOContext READONCE = new IOContext(ReadAdvice.SEQUENTIAL);
    private static final IOContext[] READADVICE_TO_IOCONTEXT = (IOContext[])Arrays.stream(ReadAdvice.values()).map(IOContext::new).toArray(IOContext[]::new);

    public IOContext {
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(readAdvice, "readAdvice must not be null");
        switch (context.ordinal()) {
            case 0: {
                Objects.requireNonNull(mergeInfo, "mergeInfo must not be null if context is MERGE");
                break;
            }
            case 1: {
                Objects.requireNonNull(flushInfo, "flushInfo must not be null if context is FLUSH");
            }
        }
        if ((context == Context.FLUSH || context == Context.MERGE) && readAdvice != ReadAdvice.SEQUENTIAL) {
            throw new IllegalArgumentException("The FLUSH and MERGE contexts must use the SEQUENTIAL read access advice");
        }
    }

    private IOContext(ReadAdvice accessAdvice) {
        this(Context.DEFAULT, null, null, accessAdvice);
    }

    public IOContext(FlushInfo flushInfo) {
        this(Context.FLUSH, null, flushInfo, ReadAdvice.SEQUENTIAL);
    }

    public IOContext(MergeInfo mergeInfo) {
        this(Context.MERGE, mergeInfo, null, ReadAdvice.SEQUENTIAL);
    }

    public IOContext withReadAdvice(ReadAdvice advice) {
        if (this.context == Context.DEFAULT) {
            return READADVICE_TO_IOCONTEXT[advice.ordinal()];
        }
        return this;
    }

    public static enum Context {
        MERGE,
        FLUSH,
        DEFAULT;

    }
}

