/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.search.BulkScorer;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.LeafCollector;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.util.Bits;

final class ReqExclBulkScorer
extends BulkScorer {
    private final BulkScorer req;
    private final DocIdSetIterator exclApproximation;
    private final TwoPhaseIterator exclTwoPhase;

    ReqExclBulkScorer(BulkScorer req, Scorer excl) {
        this.req = req;
        this.exclTwoPhase = excl.twoPhaseIterator();
        this.exclApproximation = this.exclTwoPhase != null ? this.exclTwoPhase.approximation() : excl.iterator();
    }

    ReqExclBulkScorer(BulkScorer req, DocIdSetIterator excl) {
        this.req = req;
        this.exclTwoPhase = null;
        this.exclApproximation = excl;
    }

    ReqExclBulkScorer(BulkScorer req, TwoPhaseIterator excl) {
        this.req = req;
        this.exclTwoPhase = excl;
        this.exclApproximation = excl.approximation();
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int upTo = min;
        int exclDoc = this.exclApproximation.docID();
        while (upTo < max) {
            if (exclDoc < upTo) {
                exclDoc = this.exclApproximation.advance(upTo);
            }
            if (exclDoc == upTo) {
                if (this.exclTwoPhase == null || this.exclTwoPhase.matches()) {
                    ++upTo;
                }
                exclDoc = this.exclApproximation.nextDoc();
                continue;
            }
            upTo = this.req.score(collector, acceptDocs, upTo, Math.min(exclDoc, max));
        }
        if (upTo == max) {
            upTo = this.req.score(collector, acceptDocs, upTo, upTo);
        }
        return upTo;
    }

    @Override
    public long cost() {
        return this.req.cost();
    }
}

