/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes;

import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.parser.EscapeQuerySyntax;

public class QuotedFieldQueryNode
extends FieldQueryNode {
    public QuotedFieldQueryNode(CharSequence field, CharSequence text, int begin, int end) {
        super(field, text, begin, end);
    }

    @Override
    public CharSequence toQueryString(EscapeQuerySyntax escaper) {
        if (this.isDefaultField(this.field)) {
            return "\"" + String.valueOf(this.getTermEscapeQuoted(escaper)) + "\"";
        }
        return String.valueOf(this.field) + ":\"" + String.valueOf(this.getTermEscapeQuoted(escaper)) + "\"";
    }

    @Override
    public String toString() {
        return "<quotedfield start='" + this.begin + "' end='" + this.end + "' field='" + String.valueOf(this.field) + "' term='" + String.valueOf(this.text) + "'/>";
    }

    @Override
    public QuotedFieldQueryNode cloneTree() throws CloneNotSupportedException {
        QuotedFieldQueryNode clone = (QuotedFieldQueryNode)super.cloneTree();
        return clone;
    }
}

