/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.NumericDocValues;
import org.apache.lucene.ars_nouveau.queries.function.FunctionValues;
import org.apache.lucene.ars_nouveau.queries.function.ValueSource;
import org.apache.lucene.ars_nouveau.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.IDFValueSource;
import org.apache.lucene.ars_nouveau.search.CollectionStatistics;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.TermStatistics;
import org.apache.lucene.ars_nouveau.search.similarities.Similarity;
import org.apache.lucene.ars_nouveau.search.similarities.TFIDFSimilarity;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class NormValueSource
extends ValueSource {
    protected final String field;

    public NormValueSource(String field) {
        this.field = field;
    }

    public String name() {
        return "norm";
    }

    @Override
    public String description() {
        return this.name() + "(" + this.field + ")";
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        context.put("searcher", searcher);
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        TFIDFSimilarity similarity = IDFValueSource.asTFIDF(searcher.getSimilarity(), this.field);
        if (similarity == null) {
            throw new UnsupportedOperationException("requires a TFIDFSimilarity (such as ClassicSimilarity)");
        }
        final Similarity.SimScorer simScorer = similarity.scorer(1.0f, new CollectionStatistics(this.field, 1L, 1L, 1L, 1L), new TermStatistics(new BytesRef("bogus"), 1L, 1L));
        final NumericDocValues norms = readerContext.reader().getNormValues(this.field);
        return new FloatDocValues(this, this){
            int lastDocID;
            {
                super(vs);
                this.lastDocID = -1;
            }

            @Override
            public float floatVal(int docID) throws IOException {
                if (docID < this.lastDocID) {
                    throw new AssertionError((Object)("docs out of order: lastDocID=" + this.lastDocID + " docID=" + docID));
                }
                this.lastDocID = docID;
                long norm = 1L;
                if (norms != null && norms.advanceExact(docID)) {
                    norm = norms.longValue();
                }
                return simScorer.score(1.0f, norm);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.field.equals(((NormValueSource)o).field);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.field.hashCode();
    }
}

