/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.geo;

import org.apache.lucene.ars_nouveau.geo.Component2D;
import org.apache.lucene.ars_nouveau.geo.EdgeTree;
import org.apache.lucene.ars_nouveau.geo.Line;
import org.apache.lucene.ars_nouveau.geo.XYEncodingUtils;
import org.apache.lucene.ars_nouveau.geo.XYLine;
import org.apache.lucene.ars_nouveau.index.PointValues;

final class Line2D
implements Component2D {
    private final double minY;
    private final double maxY;
    private final double minX;
    private final double maxX;
    private final EdgeTree tree;

    private Line2D(Line line) {
        this.minY = line.minLat;
        this.maxY = line.maxLat;
        this.minX = line.minLon;
        this.maxX = line.maxLon;
        this.tree = EdgeTree.createTree(line.getLons(), line.getLats());
    }

    private Line2D(XYLine line) {
        this.minY = line.minY;
        this.maxY = line.maxY;
        this.minX = line.minX;
        this.maxX = line.maxX;
        this.tree = EdgeTree.createTree(XYEncodingUtils.floatArrayToDoubleArray(line.getX()), XYEncodingUtils.floatArrayToDoubleArray(line.getY()));
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        if (Component2D.containsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY)) {
            return this.tree.isPointOnLine(x, y);
        }
        return false;
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        return this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true);
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        return Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, aX, aY, bX, bY, cX, cY) || this.tree.crossesTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, true);
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return false;
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return false;
    }

    @Override
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (ab && this.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, bX, bY, cX, cY, true)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, cX, cY, aX, aY, true)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    static Component2D create(Line line) {
        return new Line2D(line);
    }

    static Component2D create(XYLine line) {
        return new Line2D(line);
    }
}

