/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.facetset;

import org.apache.lucene.ars_nouveau.util.NumericUtils;

public record DimRange(long min, long max) {
    public static DimRange fromLongs(long min, boolean minInclusive, long max, boolean maxInclusive) {
        if (!minInclusive) {
            if (min != Long.MAX_VALUE) {
                ++min;
            } else {
                throw new IllegalArgumentException("Invalid min input: " + min);
            }
        }
        if (!maxInclusive) {
            if (max != Long.MIN_VALUE) {
                --max;
            } else {
                throw new IllegalArgumentException("Invalid max input: " + max);
            }
        }
        if (min > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum, max=" + max + ", min=" + min);
        }
        return new DimRange(min, max);
    }

    public static DimRange fromDoubles(double min, boolean minInclusive, double max, boolean maxInclusive) {
        if (Double.isNaN(min)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min = Math.nextUp(min);
        }
        if (Double.isNaN(max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max = Math.nextDown(max);
        }
        if (min > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
        return new DimRange(NumericUtils.doubleToSortableLong(min), NumericUtils.doubleToSortableLong(max));
    }

    public static DimRange fromFloats(float min, boolean minInclusive, float max, boolean maxInclusive) {
        if (Float.isNaN(min)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min = Math.nextUp(min);
        }
        if (Float.isNaN(max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max = Math.nextDown(max);
        }
        if (min > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
        return new DimRange(NumericUtils.floatToSortableInt(min), NumericUtils.floatToSortableInt(max));
    }
}

