/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.document.DocValuesLongHashSet;
import org.apache.lucene.ars_nouveau.index.DocValues;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.NumericDocValues;
import org.apache.lucene.ars_nouveau.index.SortedNumericDocValues;
import org.apache.lucene.ars_nouveau.search.ConstantScoreScorer;
import org.apache.lucene.ars_nouveau.search.ConstantScoreWeight;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.MatchNoDocsQuery;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.ScorerSupplier;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.search.Weight;
import org.apache.lucene.ars_nouveau.util.Accountable;
import org.apache.lucene.ars_nouveau.util.RamUsageEstimator;

final class SortedNumericDocValuesSetQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(SortedNumericDocValuesSetQuery.class);
    private final String field;
    private final DocValuesLongHashSet numbers;

    SortedNumericDocValuesSetQuery(String field, long[] numbers) {
        this.field = Objects.requireNonNull(field);
        Arrays.sort(numbers);
        this.numbers = new DocValuesLongHashSet(numbers);
    }

    @Override
    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        SortedNumericDocValuesSetQuery that = (SortedNumericDocValuesSetQuery)other;
        return this.field.equals(that.field) && this.numbers.equals(that.numbers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.numbers);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String defaultField) {
        return this.field + ": " + this.numbers.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.field) + RamUsageEstimator.sizeOfObject(this.numbers);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.numbers.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesSetQuery.this.field);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesSetQuery.this.field) == null) {
                    return null;
                }
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), SortedNumericDocValuesSetQuery.this.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton(values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(singleton){

                    @Override
                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return value >= SortedNumericDocValuesSetQuery.this.numbers.minValue && value <= SortedNumericDocValuesSetQuery.this.numbers.maxValue && SortedNumericDocValuesSetQuery.this.numbers.contains(value);
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (value < SortedNumericDocValuesSetQuery.this.numbers.minValue) continue;
                            if (value > SortedNumericDocValuesSetQuery.this.numbers.maxValue) {
                                return false;
                            }
                            if (!SortedNumericDocValuesSetQuery.this.numbers.contains(value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, iterator);
                return new Weight.DefaultScorerSupplier(scorer);
            }
        };
    }
}

