/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.saved_data;

import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec2;

public class JarDimData
extends SavedData {
    public static Codec<Map<UUID, RotPos>> ENTERED_FROM_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)RotPos.CODEC.codec());
    private Map<UUID, RotPos> enteredFrom = new HashMap<UUID, RotPos>();
    private BlockPos spawnPos = new BlockPos(7, 2, 7);

    public void setEnteredFrom(UUID uuid, GlobalPos pos, Vec2 rot) {
        this.enteredFrom.put(uuid, new RotPos(pos, rot));
        this.setDirty();
    }

    @Nullable
    public RotPos getEnteredFrom(UUID uuid) {
        return this.enteredFrom.get(uuid);
    }

    public void setSpawnPos(BlockPos pos) {
        this.spawnPos = pos;
        this.setDirty();
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (!this.enteredFrom.isEmpty()) {
            compoundTag.put("enteredFrom", ANCodecs.encode(ENTERED_FROM_CODEC, this.enteredFrom));
        }
        compoundTag.put("spawnPos", ANCodecs.encode(BlockPos.CODEC, this.spawnPos));
        return compoundTag;
    }

    public static JarDimData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        JarDimData data = new JarDimData();
        if (compoundTag.contains("enteredFrom")) {
            data.enteredFrom = new HashMap<UUID, RotPos>(ANCodecs.decode(ENTERED_FROM_CODEC, (Tag)compoundTag.getCompound("enteredFrom")));
        }
        if (compoundTag.contains("spawnPos")) {
            data.spawnPos = (BlockPos)ANCodecs.decode(BlockPos.CODEC, compoundTag.get("spawnPos"));
        }
        return data;
    }

    public static JarDimData from(ServerLevel level) {
        return (JarDimData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(JarDimData::new, JarDimData::load, null), "jar_data");
    }

    public record RotPos(GlobalPos pos, Vec2 rot) {
        public static final MapCodec<RotPos> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(RotPos::pos), (App)ANCodecs.VEC2.fieldOf("rot").forGetter(RotPos::rot)).apply((Applicative)instance, RotPos::new));
    }
}

