/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.AABB;

public class RitualBreed
extends AbstractRitual {
    long lastTick = -1L;
    boolean tooManyAnimals = false;

    @Override
    protected void tick() {
        if (this.getWorld().isClientSide) {
            ParticleUtil.spawnRitualAreaEffect(this.getPos(), this.getWorld(), this.rand, this.getCenterColor(), 5);
        } else if (this.getWorld().getGameTime() % 200L == 0L) {
            List animals = this.getWorld().getEntitiesOfClass(Animal.class, new AABB(this.getPos()).inflate(5.0));
            if (animals.size() >= 20) {
                return;
            }
            boolean didWorkOnce = false;
            for (Animal a : animals) {
                if (a.getAge() != 0 || !a.canFallInLove()) continue;
                didWorkOnce = true;
                a.setInLove(null);
            }
            if (didWorkOnce) {
                this.setNeedsSource(true);
            }
        }
    }

    @Override
    public void modifyTooltips(List<Component> tooltips) {
        long lastCheck = this.getWorld().getGameTime();
        if (lastCheck != this.lastTick && lastCheck % 20L == 0L) {
            List animals = this.getWorld().getEntitiesOfClass(Animal.class, new AABB(this.getPos()).inflate(5.0));
            this.tooManyAnimals = animals.size() >= 20;
            this.lastTick = lastCheck;
        }
        if (this.tooManyAnimals) {
            tooltips.add((Component)Component.translatable((String)"ars_nouveau.tooltip.too_many_animals"));
        }
    }

    @Override
    public String getLangDescription() {
        return "Periodically causes nearby animals to breed if possible. This ritual requires source to operate, and will have no effect if there are twenty or more animals nearby.";
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(100, 255, 100);
    }

    @Override
    public String getLangName() {
        return "Fertility";
    }

    @Override
    public int getSourceCost() {
        return 500;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.FERTILITY);
    }
}

