/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.perk;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.perk.Perk;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;

public class MagicResistPerk
extends Perk {
    public static final MagicResistPerk INSTANCE = new MagicResistPerk(ArsNouveau.prefix("thread_warding"));

    public MagicResistPerk(ResourceLocation key) {
        super(key);
    }

    @Override
    @NotNull
    public ItemAttributeModifiers applyAttributeModifiers(ItemAttributeModifiers modifiers, ItemStack stack, int slotValue, EquipmentSlotGroup equipmentSlotGroup) {
        return modifiers.withModifierAdded(PerkAttributes.WARDING, new AttributeModifier(INSTANCE.getRegistryName(), (double)(2 * slotValue), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
    }

    @Override
    public String getLangName() {
        return "Warding";
    }

    @Override
    public String getLangDescription() {
        return "Reduces the amount of magic damage taken by a flat amount each level.";
    }
}

