/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PotionSyncPacket
extends AbstractPacket {
    public int entity;
    public int duration;
    public ResourceLocation effect;
    public static final CustomPacketPayload.Type<PotionSyncPacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("potion_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionSyncPacket> CODEC = StreamCodec.ofMember(PotionSyncPacket::toBytes, PotionSyncPacket::new);

    public PotionSyncPacket(int entity, ResourceLocation effect, int duration) {
        this.entity = entity;
        this.effect = effect;
        this.duration = duration;
    }

    public PotionSyncPacket(int entity, MobEffect effect, int duration) {
        this.entity = entity;
        this.effect = PotionSyncPacket.getRegistryName(effect);
        this.duration = duration;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf RegistryFriendlyByteBuf2) {
        RegistryFriendlyByteBuf2.writeInt(this.entity);
        RegistryFriendlyByteBuf2.writeResourceLocation(this.effect);
        RegistryFriendlyByteBuf2.writeInt(this.duration);
    }

    public PotionSyncPacket(RegistryFriendlyByteBuf RegistryFriendlyByteBuf2) {
        this.entity = RegistryFriendlyByteBuf2.readInt();
        this.effect = RegistryFriendlyByteBuf2.readResourceLocation();
        this.duration = RegistryFriendlyByteBuf2.readInt();
    }

    @Override
    public void onClientReceived(Minecraft mc, Player player) {
        LivingEntity living;
        Entity entity = mc.level.getEntity(this.entity);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity) != ArsNouveau.proxy.getPlayer()) {
            Holder effect = BuiltInRegistries.MOB_EFFECT.getHolder(this.effect).orElse(null);
            if (effect == null) {
                return;
            }
            if (this.duration > 0) {
                living.addEffect(new MobEffectInstance(effect, this.duration, 0, false, false, false));
            } else {
                living.removeEffect(effect);
            }
        }
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

