/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class PacketUpdateParticleTimeline
extends AbstractPacket {
    int castSlot;
    TimelineMap color;
    boolean mainHand;
    public static final CustomPacketPayload.Type<PacketUpdateParticleTimeline> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("update_particle_timeline"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateParticleTimeline> CODEC = StreamCodec.ofMember(PacketUpdateParticleTimeline::toBytes, PacketUpdateParticleTimeline::new);

    public PacketUpdateParticleTimeline(int slot, TimelineMap color, boolean mainHand) {
        this.castSlot = slot;
        this.color = color;
        this.mainHand = mainHand;
    }

    public PacketUpdateParticleTimeline(RegistryFriendlyByteBuf buf) {
        this.castSlot = buf.readInt();
        this.color = (TimelineMap)TimelineMap.STREAM.decode((Object)buf);
        this.mainHand = buf.readBoolean();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.castSlot);
        TimelineMap.STREAM.encode((Object)buf, (Object)this.color);
        buf.writeBoolean(this.mainHand);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        AbstractCaster<?> caster;
        ItemStack stack = player.getItemInHand(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        if (stack.getItem() instanceof SpellBook && (caster = SpellCasterRegistry.from(stack)) != null) {
            ((AbstractCaster)caster.setParticles(this.color, this.castSlot)).saveToStack(stack);
            Networking.sendToPlayerClient(new PacketUpdateBookGUI(stack), player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

