/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.common.block.MobJar;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SnowGolemBehavior
extends JarBehavior<SnowGolem> {
    @Override
    public void onRedstonePower(MobJarTile tile) {
        Level level = tile.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        SnowGolem golem = (SnowGolem)this.entityFromJar(tile);
        Snowball snowball = new Snowball((Level)level2, (LivingEntity)golem);
        Vec3 pos = tile.getBlockPos().getCenter().add(new Vec3(((Direction)tile.getBlockState().getValue((Property)MobJar.FACING)).step()).scale(0.6));
        Vector3f dir = ((Direction)tile.getBlockState().getValue((Property)MobJar.FACING)).step();
        snowball.setPos(pos);
        snowball.shoot((double)dir.x, (double)dir.y, (double)dir.z, 1.6f, 12.0f);
        golem.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (golem.getRandom().nextFloat() * 0.4f + 0.8f));
        level2.addFreshEntity((Entity)snowball);
    }
}

