/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.item.NBTComponent;
import com.hollingsworth.arsnouveau.common.items.data.ItemScrollData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record VoidJarData(ItemScrollData scrollData, boolean active) implements NBTComponent<VoidJarData>,
TooltipProvider
{
    public static final Codec<VoidJarData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemScrollData.CODEC.fieldOf("scrollData").forGetter(VoidJarData::scrollData), (App)Codec.BOOL.fieldOf("active").forGetter(VoidJarData::active)).apply((Applicative)instance, VoidJarData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VoidJarData> STREAM_CODEC = StreamCodec.composite(ItemScrollData.STREAM_CODEC, VoidJarData::scrollData, (StreamCodec)ByteBufCodecs.BOOL, VoidJarData::active, VoidJarData::new);

    public VoidJarData() {
        this(new ItemScrollData(), false);
    }

    public VoidJarData setActive(boolean active) {
        return new VoidJarData(this.scrollData, active);
    }

    @Override
    public Codec<VoidJarData> getCodec() {
        return CODEC;
    }

    public void addToTooltip(Item.TooltipContext pContext, Consumer<Component> pTooltipAdder, TooltipFlag pTooltipFlag) {
        if (this.active) {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.on"));
        } else {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.off"));
        }
        this.scrollData.addToTooltip(pContext, pTooltipAdder, pTooltipFlag);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoidJarData that = (VoidJarData)o;
        return this.active == that.active && Objects.equals(this.scrollData, that.scrollData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.scrollData, this.active);
    }
}

