/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandlerEntity;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.SurfaceType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;

public class PathingStuckHandler
implements IStuckHandler {
    private static final double MIN_TARGET_DIST = 3.0;
    public static final List<Direction> HORIZONTAL_DIRS = Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    private static final int MIN_TP_DELAY = 2400;
    private static final int MIN_DIST_FOR_TP = 10;
    private int teleportRange = 0;
    private int timePerBlockDistance = 200;
    private int stuckLevel = 0;
    private int globalTimeout = 0;
    private BlockPos prevDestination = BlockPos.ZERO;
    private boolean canBreakBlocks = false;
    private boolean canPlaceLadders = false;
    private boolean canBuildLeafBridges = false;
    private boolean canTeleportGoal = false;
    private int completeStuckBlockBreakRange = 0;
    private boolean hadPath = false;
    private int lastPathIndex = -1;
    private int progressedNodes = 0;
    private int delayBeforeActions;
    private int delayToNextUnstuckAction = this.delayBeforeActions = 200;
    private BlockPos moveAwayStartPos = BlockPos.ZERO;
    private Random rand = new Random();

    private PathingStuckHandler() {
    }

    public static PathingStuckHandler createStuckHandler() {
        return new PathingStuckHandler();
    }

    @Override
    public void checkStuck(AbstractAdvancedPathNavigate navigator) {
        if (navigator.getDesiredPos() == null || navigator.getDesiredPos().equals((Object)BlockPos.ZERO)) {
            return;
        }
        if (navigator.getOurEntity() instanceof IStuckHandlerEntity && !((IStuckHandlerEntity)navigator.getOurEntity()).canBeStuck()) {
            this.resetGlobalStuckTimers();
            return;
        }
        double distanceToGoal = navigator.getOurEntity().position().distanceTo(new Vec3((double)navigator.getDesiredPos().getX(), (double)navigator.getDesiredPos().getY(), (double)navigator.getDesiredPos().getZ()));
        if (distanceToGoal < 3.0) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (this.prevDestination.equals((Object)navigator.getDesiredPos())) {
            ++this.globalTimeout;
            if ((double)this.globalTimeout > Math.max(2400.0, (double)this.timePerBlockDistance * Math.max(10.0, distanceToGoal))) {
                this.completeStuckAction(navigator);
            }
        } else {
            this.resetGlobalStuckTimers();
        }
        --this.delayToNextUnstuckAction;
        this.prevDestination = navigator.getDesiredPos();
        if (navigator.getPath() == null || navigator.getPath().isDone()) {
            this.lastPathIndex = -1;
            this.progressedNodes = 0;
            if (!this.hadPath) {
                this.tryUnstuck(navigator);
            }
        } else if (navigator.getPath().getNextNodeIndex() == this.lastPathIndex) {
            this.tryUnstuck(navigator);
        } else if (this.lastPathIndex != -1 && navigator.getPath().getTarget().distSqr((Vec3i)this.prevDestination) < 25.0) {
            int n = this.progressedNodes = navigator.getPath().getNextNodeIndex() > this.lastPathIndex ? this.progressedNodes + 1 : this.progressedNodes - 1;
            if (!(this.progressedNodes <= 5 || navigator.getPath().getEndNode() != null && this.moveAwayStartPos.equals((Object)navigator.getPath().getEndNode().asBlockPos()))) {
                this.resetStuckTimers();
            }
        }
        this.lastPathIndex = navigator.getPath() != null ? navigator.getPath().getNextNodeIndex() : -1;
        this.hadPath = navigator.getPath() != null && !navigator.getPath().isDone();
    }

    private void resetGlobalStuckTimers() {
        this.globalTimeout = 0;
        this.prevDestination = BlockPos.ZERO;
        this.resetStuckTimers();
    }

    private void completeStuckAction(AbstractAdvancedPathNavigate navigator) {
        BlockPos tpPos;
        BlockPos desired = navigator.getDesiredPos();
        Level world = navigator.getOurEntity().level;
        Mob entity = navigator.getOurEntity();
        if (this.canTeleportGoal && (tpPos = PathingStuckHandler.findAround(world, desired, 10, 10, (posworld, pos) -> SurfaceType.getSurfaceType(posworld, posworld.getBlockState(pos.below()), pos.below()) == SurfaceType.WALKABLE && SurfaceType.getSurfaceType(posworld, posworld.getBlockState(pos), pos) == SurfaceType.DROPABLE && SurfaceType.getSurfaceType(posworld, posworld.getBlockState(pos.above()), pos.above()) == SurfaceType.DROPABLE)) != null) {
            entity.teleportTo((double)tpPos.getX() + 0.5, (double)tpPos.getY(), (double)tpPos.getZ() + 0.5);
        }
        if (this.completeStuckBlockBreakRange > 0) {
            Direction facing = PathingStuckHandler.getFacing(BlockPos.containing((Position)entity.position()), navigator.getDesiredPos());
            for (int i = 1; i <= this.completeStuckBlockBreakRange; ++i) {
                if (world.isEmptyBlock(BlockPos.containing((Position)entity.position()).relative(facing, i)) && world.isEmptyBlock(BlockPos.containing((Position)entity.position()).relative(facing, i).above())) continue;
                this.breakBlocksAhead(world, BlockPos.containing((Position)entity.position()).relative(facing, i - 1), facing);
                break;
            }
        }
        navigator.stop();
        this.resetGlobalStuckTimers();
    }

    private void tryUnstuck(AbstractAdvancedPathNavigate navigator) {
        if (this.delayToNextUnstuckAction > 0) {
            return;
        }
        this.delayToNextUnstuckAction = 50;
        if (this.stuckLevel == 0) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 100;
            navigator.getOurEntity().stopRiding();
            navigator.stop();
            return;
        }
        if (this.stuckLevel == 1) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 300;
            this.moveAwayStartPos = navigator.getPath() != null ? navigator.getPath().getNodePos(navigator.getPath().getNextNodeIndex()) : navigator.getOurEntity().blockPosition().above();
            navigator.stop();
            navigator.moveAwayFromXYZ(navigator.getOurEntity().blockPosition(), 10.0, 1.0, false);
            return;
        }
        if (this.stuckLevel == 2 && this.teleportRange > 0 && this.hadPath) {
            int index = Math.min(navigator.getPath().getNextNodeIndex() + this.teleportRange, navigator.getPath().getNodeCount() - 1);
            Node togo = navigator.getPath().getNode(index);
            navigator.getOurEntity().teleportTo((double)togo.x + 0.5, (double)togo.y, (double)togo.z + 0.5);
            this.delayToNextUnstuckAction = 300;
        }
        if (this.stuckLevel >= 3 && this.stuckLevel <= 5) {
            if (this.canPlaceLadders && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 200;
            } else if (this.canBuildLeafBridges && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 100;
                this.placeLeaves(navigator);
            } else if (this.canPlaceLadders || this.canBuildLeafBridges) {
                return;
            }
        }
        if (this.stuckLevel >= 6 && this.stuckLevel <= 8 && this.canBreakBlocks) {
            this.delayToNextUnstuckAction = 200;
            this.breakBlocks(navigator);
        }
        this.chanceStuckLevel();
        if (this.stuckLevel == 9) {
            this.completeStuckAction(navigator);
            this.resetStuckTimers();
        }
    }

    private void chanceStuckLevel() {
        ++this.stuckLevel;
        if (this.stuckLevel > 1 && this.rand.nextInt(6) == 0) {
            this.stuckLevel -= 2;
        }
    }

    private void resetStuckTimers() {
        this.delayToNextUnstuckAction = this.delayBeforeActions;
        this.lastPathIndex = -1;
        this.progressedNodes = 0;
        this.stuckLevel = 0;
        this.moveAwayStartPos = BlockPos.ZERO;
    }

    private void breakBlocksAhead(Level world, BlockPos start, Direction facing) {
        if (!world.isEmptyBlock(start.above(3))) {
            this.setAirIfPossible(world, start.above(3));
            return;
        }
        if (!world.isEmptyBlock(start.above().relative(facing))) {
            this.setAirIfPossible(world, start.above().relative(facing));
            return;
        }
        if (!world.isEmptyBlock(start.relative(facing))) {
            this.setAirIfPossible(world, start.relative(facing));
        }
    }

    private void setAirIfPossible(Level world, BlockPos pos) {
        Block blockAtPos;
        BlockState state = world.getBlockState(pos);
        if (state.is(blockAtPos = state.getBlock())) {
            return;
        }
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    private void placeLeaves(AbstractAdvancedPathNavigate navigator) {
        Level world = navigator.getOurEntity().level;
        Mob entity = navigator.getOurEntity();
        Direction badFacing = PathingStuckHandler.getFacing(BlockPos.containing((Position)entity.position()), navigator.getDesiredPos()).getOpposite();
        for (Direction dir : HORIZONTAL_DIRS) {
            if (dir == badFacing) continue;
            for (int i = 1; i <= (dir == badFacing.getOpposite() ? 3 : 1) && this.tryPlaceLeaveOnPos(world, BlockPos.containing((Position)entity.position()).below().relative(dir, i)); ++i) {
            }
        }
    }

    private boolean tryPlaceLeaveOnPos(Level world, BlockPos pos) {
        if (world.isEmptyBlock(pos)) {
            world.setBlockAndUpdate(pos, Blocks.ACACIA_LEAVES.defaultBlockState());
            return true;
        }
        return false;
    }

    private void breakBlocks(AbstractAdvancedPathNavigate navigator) {
        Level world = navigator.getOurEntity().level;
        Mob entity = navigator.getOurEntity();
        Direction facing = PathingStuckHandler.getFacing(BlockPos.containing((Position)entity.position()), navigator.getDesiredPos());
        this.breakBlocksAhead(world, BlockPos.containing((Position)entity.position()), facing);
    }

    public PathingStuckHandler withBlockBreaks() {
        this.canBreakBlocks = true;
        return this;
    }

    public PathingStuckHandler withPlaceLadders() {
        this.canPlaceLadders = true;
        return this;
    }

    public PathingStuckHandler withBuildLeafBridges() {
        this.canBuildLeafBridges = true;
        return this;
    }

    public PathingStuckHandler withTeleportSteps(int steps) {
        this.teleportRange = steps;
        return this;
    }

    public PathingStuckHandler withTeleportOnFullStuck() {
        this.canTeleportGoal = true;
        return this;
    }

    public PathingStuckHandler withTimePerBlockDistance(int time) {
        this.timePerBlockDistance = time;
        return this;
    }

    public PathingStuckHandler withDelayBeforeStuckActions(int delay) {
        this.delayBeforeActions = delay;
        return this;
    }

    public PathingStuckHandler withCompleteStuckBlockBreak(int range) {
        this.completeStuckBlockBreakRange = range;
        return this;
    }

    public static BlockPos findAround(Level world, BlockPos start, int vRange, int hRange, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (vRange < 1 && hRange < 1) {
            return null;
        }
        if (predicate.test((BlockGetter)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < hRange + 2; ++i) {
            for (int steps = 1; steps <= vRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.offset(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (PathingStuckHandler.isInWorldHeight(start.getY() + (y += (y_offset *= -1)), world)) continue;
            return null;
        }
        return null;
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.dimensionType();
        return yBlock > dimensionType.minY() && yBlock < dimensionType.logicalHeight() + dimensionType.minY();
    }

    public static Direction getFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.subtract((Vec3i)pos);
        return Direction.getNearest((float)vector.getX(), (float)vector.getY(), (float)vector.getZ());
    }
}

