/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.crafting.recipes.BuddingConversionRecipe;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;

public class ConvertBuddingGoal
extends Goal {
    public AmethystGolem golem;
    public Supplier<Boolean> canUse;
    BlockPos targetCluster;
    int usingTicks;
    boolean isDone;

    public ConvertBuddingGoal(AmethystGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public boolean canContinueToUse() {
        return this.targetCluster != null && !this.isDone;
    }

    public void tick() {
        super.tick();
        --this.usingTicks;
        this.golem.getNavigation().tryMoveToBlockPos(this.targetCluster, 1.0);
        if (this.usingTicks <= 0) {
            this.isDone = true;
            this.convert();
            return;
        }
        if (BlockUtil.distanceFrom(this.golem.blockPosition(), this.targetCluster) <= 2.0) {
            this.golem.setImbuePos(this.targetCluster);
            this.golem.setImbueing(true);
            this.usingTicks = Math.min(this.usingTicks, 40);
        }
    }

    public void convert() {
        if (this.targetCluster != null) {
            BlockState targetState = this.golem.level.getBlockState(this.targetCluster);
            Optional<BuddingConversionRecipe> recipe = this.golem.recipes.stream().filter(r -> r.matches(targetState)).findFirst();
            recipe.ifPresent(r -> {
                this.golem.level.setBlock(this.targetCluster, r.result().defaultBlockState(), 3);
                ParticleUtil.spawnTouchPacket(this.golem.level, this.targetCluster, ParticleColor.defaultParticleColor());
            });
        }
        this.golem.convertCooldown = 6000;
        this.golem.setImbueing(false);
        this.golem.setImbuePos(BlockPos.ZERO);
    }

    public void start() {
        this.isDone = false;
        this.usingTicks = 120;
        block0: for (BlockPos pos : this.golem.amethystBlocks) {
            for (BuddingConversionRecipe recipe : this.golem.recipes) {
                if (!recipe.matches(this.golem.level.getBlockState(pos))) continue;
                this.targetCluster = pos;
                break block0;
            }
        }
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.CONVERT;
    }

    public void stop() {
        this.golem.setImbueing(false);
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canUse() {
        return this.canUse.get() != false && this.golem.convertCooldown <= 0 && !this.golem.amethystBlocks.isEmpty();
    }
}

