/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.hollingsworth.arsnouveau.common.entity.EnchantedSkull;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AnimHeadSummon
extends AnimBlockSummon {
    public AnimHeadSummon(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AnimHeadSummon(Level pLevel, BlockState state, CompoundTag head_data) {
        super((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.ANIMATED_HEAD.get()), pLevel, head_data);
        this.blockState = state;
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ANIMATED_HEAD.get();
    }

    @Override
    public void returnToFallingBlock(BlockState blockState) {
        if (this.level.isClientSide || !this.dropItem || blockState == null) {
            return;
        }
        EnchantedSkull fallingBlock = new EnchantedSkull(this.level, this.blockPosition(), blockState);
        fallingBlock.setOwner((Entity)this.getOwner());
        fallingBlock.setDeltaMovement(this.getDeltaMovement());
        fallingBlock.blockData = this.head_data;
        this.level.addFreshEntity((Entity)fallingBlock);
    }

    public ItemStack getStack() {
        Item item = this.getBlockState().getBlock().asItem();
        ItemStack stack = item.getDefaultInstance();
        if (item instanceof PlayerHeadItem && this.head_data != null) {
            ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)this.head_data.get("profile")).resultOrPartial().ifPresent(profile -> stack.set(DataComponents.PROFILE, profile));
        }
        return stack;
    }
}

