/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketToggleLight;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ToggleLightCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-light").requires(sender -> sender.hasPermission(0))).then(Commands.literal((String)"on").executes(context -> ToggleLightCommand.resetPlayers((CommandSourceStack)context.getSource(), true)))).then(Commands.literal((String)"off").executes(context -> ToggleLightCommand.resetPlayers((CommandSourceStack)context.getSource(), false))));
    }

    private static int resetPlayers(CommandSourceStack source, boolean enable) {
        ServerPlayer player;
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return 1;
        }
        Networking.sendToPlayerClient(new PacketToggleLight(enable), player);
        String path = enable ? "ars_nouveau.lights_on" : "ars_nouveau.lights_off";
        player.sendSystemMessage((Component)Component.translatable((String)path, (Object[])new Object[]{enable}));
        return 1;
    }
}

