/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.reward.Rewards;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class AdoptCommand {
    private static final SuggestionProvider<CommandSourceStack> BY_NAME = AdoptCommand.getSuggestions(starby -> starby.name);
    private static final SuggestionProvider<CommandSourceStack> BY_ADOPTER = AdoptCommand.getSuggestions(starby -> starby.adopter);

    private static SuggestionProvider<CommandSourceStack> getSuggestions(Function<Rewards.ContributorStarby, String> fn) {
        return (ctx, builder) -> {
            List suggestions = Rewards.starbuncles.stream().map(fn).toList();
            return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
        };
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-adopted").requires(sender -> sender.hasPermission(2))).then(Commands.literal((String)"by-name").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(BY_NAME).executes(ctx -> {
            Rewards.ContributorStarby starby = AdoptCommand.getStarbuncle(starbuncle -> starbuncle.name, StringArgumentType.getString((CommandContext)ctx, (String)"name"));
            return AdoptCommand.spawnStarbuncle((CommandSourceStack)ctx.getSource(), starby);
        })))).then(Commands.literal((String)"by-adopter").then(Commands.argument((String)"adopter", (ArgumentType)StringArgumentType.greedyString()).suggests(BY_ADOPTER).executes(ctx -> {
            Rewards.ContributorStarby starby = AdoptCommand.getStarbuncle(starbuncle -> starbuncle.adopter, StringArgumentType.getString((CommandContext)ctx, (String)"adopter"));
            return AdoptCommand.spawnStarbuncle((CommandSourceStack)ctx.getSource(), starby);
        }))));
    }

    private static Rewards.ContributorStarby getStarbuncle(Function<Rewards.ContributorStarby, String> selector, String match) {
        return Rewards.starbuncles.stream().filter(starbuncle -> ((String)selector.apply((Rewards.ContributorStarby)starbuncle)).equals(match)).findFirst().orElse(null);
    }

    private static int spawnStarbuncle(CommandSourceStack source, Rewards.ContributorStarby starbuncle) {
        if (starbuncle == null) {
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            return 0;
        }
        Starbuncle starby = new Starbuncle((EntityType<? extends Starbuncle>)((EntityType)ModEntities.STARBUNCLE_TYPE.get()), player.level());
        starby.setPos(player.position());
        starby.setColor(starbuncle.color);
        starby.setCustomName((Component)Component.literal((String)starbuncle.name));
        starby.data.bio = starbuncle.bio;
        starby.data.adopter = starbuncle.adopter;
        source.getLevel().addFreshEntity((Entity)starby);
        return 1;
    }
}

