/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.api.registry.CasterTomeRegistry;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CasterTomeData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.crafting.RecipeHolder;

public class AddTomeCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.suggestResource(CasterTomeRegistry.getTomeData().stream().map(RecipeHolder::id), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-tome").requires(sender -> sender.hasPermission(2))).then(Commands.argument((String)"tome", (ArgumentType)ResourceLocationArgument.id()).suggests(sugg).executes(context -> AddTomeCommand.spawnTome((CommandSourceStack)context.getSource(), String.valueOf(ResourceLocationArgument.getId((CommandContext)context, (String)"tome"))))));
    }

    private static int spawnTome(CommandSourceStack source, String tome) {
        Optional<RecipeHolder> data = CasterTomeRegistry.getTomeData().stream().filter(t -> t.id().toString().equals(tome)).findFirst();
        if (data.isPresent() && source.getPlayer() != null) {
            source.getPlayer().addItem(((CasterTomeData)data.get().value()).getResultItem((HolderLookup.Provider)source.getLevel().registryAccess()).copy());
        }
        return 1;
    }
}

